/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.Compiler;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerService;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.compiler.parser.ParserWrappers;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;

public class ApexCompiler
implements Compiler,
CompilerService {
    private final CompilationInput input;
    private final ParserWrapper originalParser;
    private final ParserWrapper additionalParser;
    private final EnumMap<CompilerStage, Queue<CodeUnit>> stagesToUnits;
    private final CompilerContext compilerContext;
    private List<CodeUnit> allUnits;

    private ApexCompiler(Builder builder) {
        this.input = builder.input;
        this.originalParser = builder.parser;
        this.additionalParser = builder.additionalParser;
        this.stagesToUnits = new EnumMap(CompilerStage.class);
        for (CompilerStage stage : CompilerStage.values()) {
            this.stagesToUnits.put(stage, Queues.newLinkedBlockingQueue());
        }
        this.compilerContext = new CompilerContext(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompilationInput getInput() {
        return this.input;
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    @Override
    public List<CodeUnit> compile() {
        return this.compile(CompilerStage.EMIT);
    }

    public List<CodeUnit> compile(CompilerStage stage) {
        assert (this.allUnits == null);
        this.allUnits = this.input.getSourceFiles().stream().map(source -> new CodeUnit(this.originalParser, (SourceFile)source)).collect(Collectors.toList());
        this.stagesToUnits.get((Object)CompilerStage.WAITING).addAll(this.allUnits);
        this.compileInternal(stage);
        this.compilerContext.getEmitter().assertEmpty();
        return this.allUnits;
    }

    private void compileInternal(CompilerStage ensureCompletedStage) {
        this.compilerContext.getLocalContexts().push(new CompilerContext.LocalContext());
        try {
            while (this.processNext(ensureCompletedStage)) {
            }
        }
        finally {
            this.compilerContext.getLocalContexts().pop();
        }
    }

    @Override
    public TypeInfo attachAdditionalSource(SymbolResolver symbolResolver, SourceFile sourceFile, String fullNameLower) {
        CodeUnit newCodeUnit = new CodeUnit(this.additionalParser, sourceFile);
        this.allUnits.add(newCodeUnit);
        this.stagesToUnits.get((Object)CompilerStage.WAITING).add(newCodeUnit);
        Optional<CompilerStage> current = Optional.ofNullable(this.compilerContext.getCurrentStages().peek());
        this.compileInternal(current.map(CompilerStage::getPrevious).orElse(CompilerStage.EMIT));
        return fullNameLower.lastIndexOf(36) == -1 ? newCodeUnit.getType() : symbolResolver.get(fullNameLower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNext(CompilerStage ensureCompletedStage) {
        CompilerStage[] values;
        if (ensureCompletedStage == CompilerStage.WAITING) {
            return false;
        }
        for (CompilerStage stage : values = CompilerStage.values()) {
            if (stage == ensureCompletedStage) {
                return false;
            }
            if (this.stagesToUnits.get((Object)stage).isEmpty()) continue;
            CodeUnit unitToProcess = this.stagesToUnits.get((Object)stage).poll();
            CompilerStage nextStage = stage.getNext();
            assert (nextStage != null);
            this.compilerContext.getCurrentStages().push(nextStage);
            try {
                nextStage.getOperation().invoke(this.compilerContext, unitToProcess);
            }
            finally {
                this.compilerContext.getCurrentStages().pop();
            }
            this.stagesToUnits.get((Object)nextStage).add(unitToProcess);
            return true;
        }
        assert (false) : "We should never get here.";
        return false;
    }

    public List<CompilationOutput> compileThrowErrors() {
        List<CodeUnit> units = this.compile();
        this.throwErrorsIfAny();
        return units.stream().map(CodeUnit::getOutput).collect(MoreIterables.toUnmodifiableList(units.size()));
    }

    public List<CompilationException> getErrors() {
        int size = this.allUnits.stream().mapToInt(unit -> unit.getErrors().get().size()).reduce((x, y) -> x + y).getAsInt();
        return this.allUnits.stream().map(unit -> unit.getErrors().get()).flatMap(Collection::stream).collect(MoreIterables.toUnmodifiableList(size));
    }

    public void throwErrorsIfAny() {
        List<CompilationException> errors = this.getErrors();
        if (!errors.isEmpty()) {
            throw errors.get(0);
        }
    }

    public List<ListMultimap<TypeInfo, ExternalDependency>> getReferences() {
        return this.allUnits.stream().filter(unit -> !unit.getReferences().isEmpty()).map(CodeUnit::getReferences).collect(MoreIterables.toUnmodifiableList());
    }

    public static class Builder {
        private final ParserWrapper additionalParser;
        private CompilationInput input;
        private ParserWrapper parser;

        private Builder() {
            this.parser = this.additionalParser = ParserWrappers.get(ParserWrapper.Type.NAMED);
        }

        public ApexCompiler build() {
            assert (this.input != null);
            return new ApexCompiler(this);
        }

        public Builder setInput(CompilationInput input) {
            this.input = input;
            return this;
        }

        public Builder setParserType(ParserWrapper.Type parserType) {
            this.parser = ParserWrappers.get(parserType);
            return this;
        }
    }
}

