/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.util;

import apex.jorje.semantic.common.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FileUtilTest {
    private static final String FILE_NAME = "foobar.class";

    @BeforeMethod
    public void setup() throws Exception {
        Files.write(FileUtil.get().resolve(FILE_NAME), new byte[0], new OpenOption[0]);
    }

    @AfterMethod
    public void tearDown() {
        try {
            Files.deleteIfExists(FileUtil.get().resolve(FILE_NAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadFile() throws Exception {
        Path path = FileUtil.get().loadFile(FILE_NAME);
        MatcherAssert.assertThat((Object)path, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testReadFile() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(FILE_NAME);
        Path path = Paths.get(url.toURI());
        MatcherAssert.assertThat((Object)FileUtil.get().readFile(path), (Matcher)Matchers.emptyString());
    }

    @Test
    public void testDeleteFile() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(FILE_NAME);
        Path path = Paths.get(url.toURI());
        MatcherAssert.assertThat((Object)FileUtil.get().deleteFile(path), (Matcher)Matchers.is((Object)true));
    }
}

