/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterator;

import apex.jorje.semantic.common.iterator.NotEqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class UnequalPairIteratorTest {
    private static final List<String> STRINGS = ImmutableList.of("foo", "bar");
    private static final List<Integer> INTEGERS = ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    private static final List<String> EMPTY_LIST = Collections.emptyList();

    @Test
    public void testEmptyList() {
        Iterator<Pair<String, String>> it = NotEqualPairIterator.iterable(EMPTY_LIST, EMPTY_LIST).iterator();
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testShorterLeft() {
        Iterator it = NotEqualPairIterator.iterable(STRINGS, INTEGERS).iterator();
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair("foo", 1, it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair("bar", 2, it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair(null, 3, it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testShorterRight() {
        Iterator it = NotEqualPairIterator.iterable(INTEGERS, STRINGS).iterator();
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair(1, "foo", it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair(2, "bar", it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)true));
        this.checkPair(3, null, it);
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testNoSuchElement() {
        Iterator<Pair<String, String>> it = NotEqualPairIterator.iterable(EMPTY_LIST, EMPTY_LIST).iterator();
        it.next();
    }

    private <T, U> void checkPair(T left, U right, Iterator<Pair<T, U>> it) {
        Pair<T, U> pair = it.next();
        MatcherAssert.assertThat((String)("Unexpected left: " + pair.toString()), left, (Matcher)Matchers.is(pair.left));
        MatcherAssert.assertThat((String)("Unexpected right: " + pair.toString()), right, (Matcher)Matchers.is(pair.right));
    }
}

