/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SuperTypeIterableTest {
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo superTypeOne;
    @Mock
    private ParentTable parents;
    @Mock
    private ParentTable superParents;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.type.parents()).thenReturn((Object)this.parents);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEmptyIterator() {
        Iterator<TypeInfo> iterator = new SuperTypeIterable(null).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        iterator.next();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testRemoveThrows() {
        Iterator<TypeInfo> iterator = new SuperTypeIterable(null).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        iterator.remove();
    }

    @Test
    public void testSimple() {
        SuperTypeIterable iterable = new SuperTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type}));
    }

    @Test
    public void testClassExtends() {
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superTypeOne);
        Mockito.when((Object)this.superTypeOne.parents()).thenReturn((Object)this.superParents);
        SuperTypeIterable iterable = new SuperTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type, this.superTypeOne}));
    }

    @Test
    public void testInterfaceExtends() {
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when(this.parents.immediateInterfaces()).thenReturn(Collections.singleton(this.superTypeOne));
        Mockito.when((Object)((Object)this.superTypeOne.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when((Object)this.superTypeOne.parents()).thenReturn((Object)this.superParents);
        Mockito.when(this.superParents.immediateInterfaces()).thenReturn(Collections.emptySet());
        SuperTypeIterable iterable = new SuperTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type}));
    }
}

