/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.MoreLists;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class MoreListsTest {
    private static final Integer[] INTEGERS = new Integer[]{5, 6};
    private static final List<Integer> INTEGER_LIST = Arrays.asList(INTEGERS);

    @Test
    public void testConcatList() {
        List<Integer> result = MoreLists.concat(4, INTEGER_LIST);
        MatcherAssert.assertThat(result, (Matcher)Matchers.contains((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void testConcatArray() {
        Object[] result = MoreLists.concat("foo", INTEGERS, Object.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContaining((Object[])new Object[]{"foo", 5, 6}));
    }

    @Test
    public void testExpand() {
        Object[][] result = MoreLists.expand(INTEGERS, Object.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContaining((Object[])new Object[]{new Integer[]{5}, new Integer[]{6}}));
    }

    @Test
    public void testTo2dArray() {
        Object[][] result = MoreLists.to2dArray(Object.class, ImmutableList.of(Integer.valueOf(5)), ImmutableList.of("foo"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContaining((Object[])new Object[]{new Integer[]{5}, new String[]{"foo"}}));
    }
}

