/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;

public final class MoreLists {
    private MoreLists() {
    }

    public static <T> List<T> concat(T elem, List<T> rest) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(elem)).addAll(rest)).build();
    }

    public static <T> T[] concat(T elem, T[] rest, Class<T> type) {
        T[] result = ObjectArrays.newArray(type, rest.length + 1);
        result[0] = elem;
        System.arraycopy(rest, 0, result, 1, rest.length);
        return result;
    }

    public static <T> T[][] expand(T[] array, Class<T> clazz) {
        Object[][] expand = (Object[][])Array.newInstance(clazz, array.length, 1);
        for (int i = 0; i < array.length; ++i) {
            expand[i][0] = array[i];
        }
        return expand;
    }

    @SafeVarargs
    public static <T> T[][] to2dArray(Class<T> clazz, Collection<? extends T> ... data) {
        return MoreLists.expand(Iterables.toArray(Iterables.concat(data), clazz), clazz);
    }
}

