/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.LinkedCaseInsensitiveMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class LinkedCaseInsensitiveMapTest {
    @Test
    public void testPut() {
        LinkedCaseInsensitiveMap<Integer> map = new LinkedCaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        map.put("FOO", Integer.valueOf(6));
        MatcherAssert.assertThat(map, (Matcher)Matchers.aMapWithSize((int)1));
    }

    @Test
    public void testGet() {
        LinkedCaseInsensitiveMap<Integer> map = new LinkedCaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        MatcherAssert.assertThat(map.get("foo"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat(map.get("FOO"), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void testContainsKey() {
        LinkedCaseInsensitiveMap<Integer> map = new LinkedCaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)map.containsKey("foo"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)map.containsKey("FOO"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemove() {
        LinkedCaseInsensitiveMap<Integer> map = new LinkedCaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        map.put("bar", Integer.valueOf(7));
        MatcherAssert.assertThat(map.remove("foo"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat(map.remove("BAR"), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void testClear() {
        LinkedCaseInsensitiveMap<Integer> map = new LinkedCaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        map.put("bar", Integer.valueOf(7));
        map.clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)map.containsKey("BAR"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)map.containsKey("FOO"), (Matcher)Matchers.is((Object)false));
    }
}

