/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.ExtendedTypeIterable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.beust.jcommander.internal.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtendedTypeIterableTest {
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo superTypeOne;
    @Mock
    private TypeInfo superTypeTwo;
    @Mock
    private TypeInfo superSuperType;
    @Mock
    private ParentTable parents;
    @Mock
    private ParentTable superParents;
    @Mock
    private ParentTable superSuperParents;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.type.parents()).thenReturn((Object)this.parents);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEmptyIterator() {
        Iterator<TypeInfo> iterator = new ExtendedTypeIterable(null).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        iterator.next();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testRemoveThrows() {
        Iterator<TypeInfo> iterator = new ExtendedTypeIterable(null).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        iterator.remove();
    }

    @Test
    public void testSimple() {
        ExtendedTypeIterable iterable = new ExtendedTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type}));
    }

    @Test
    public void testClassExtends() {
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superTypeOne);
        Mockito.when((Object)this.superTypeOne.parents()).thenReturn((Object)this.superParents);
        ExtendedTypeIterable iterable = new ExtendedTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type, this.superTypeOne}));
    }

    @Test
    public void testInterfaceExtends() {
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when(this.parents.immediateInterfaces()).thenReturn(Collections.singleton(this.superTypeOne));
        Mockito.when((Object)((Object)this.superTypeOne.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when((Object)this.superTypeOne.parents()).thenReturn((Object)this.superParents);
        Mockito.when(this.superParents.immediateInterfaces()).thenReturn(Collections.emptySet());
        ExtendedTypeIterable iterable = new ExtendedTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type, this.superTypeOne}));
    }

    @Test
    public void testMultiInterfaceExtends() {
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Set parentTypes = Sets.newLinkedHashSet();
        parentTypes.addAll(Arrays.asList(this.superTypeOne, this.superTypeTwo));
        Mockito.when(this.parents.immediateInterfaces()).thenReturn((Object)parentTypes);
        Mockito.when((Object)((Object)this.superTypeOne.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when((Object)this.superTypeOne.parents()).thenReturn((Object)this.superParents);
        Mockito.when((Object)((Object)this.superTypeTwo.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when((Object)this.superTypeTwo.parents()).thenReturn((Object)this.superParents);
        Mockito.when((Object)((Object)this.superSuperType.getUnitType())).thenReturn((Object)UnitType.INTERFACE);
        Mockito.when((Object)this.superSuperType.parents()).thenReturn((Object)this.superSuperParents);
        Mockito.when(this.superSuperParents.immediateInterfaces()).thenReturn(Collections.emptySet());
        Mockito.when(this.superParents.immediateInterfaces()).thenReturn(Collections.singleton(this.superSuperType));
        ExtendedTypeIterable iterable = new ExtendedTypeIterable(this.type);
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsIterableContainingInOrder.contains((Object[])new TypeInfo[]{this.type, this.superTypeOne, this.superTypeTwo, this.superSuperType}));
    }
}

