/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.EnclosingTypeIterable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class EnclosingTypeIterableTest {
    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEmptyIterator() {
        Iterator<TypeInfo> iterator = new EnclosingTypeIterable(null).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        iterator.next();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemoveThrows() {
        TypeInfo leafTypeInfo = (TypeInfo)Mockito.mock(TypeInfo.class);
        Mockito.when((Object)leafTypeInfo.getEnclosingType()).thenReturn(null);
        Iterator<TypeInfo> iterator = new EnclosingTypeIterable(leafTypeInfo).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)leafTypeInfo));
        iterator.remove();
    }

    @Test
    public void testTwoElements() {
        TypeInfo leafTypeInfo = (TypeInfo)Mockito.mock(TypeInfo.class);
        TypeInfo middleTypeInfo = (TypeInfo)Mockito.mock(TypeInfo.class);
        TypeInfo rootTypeInfo = (TypeInfo)Mockito.mock(TypeInfo.class);
        Mockito.when((Object)leafTypeInfo.getEnclosingType()).thenReturn((Object)middleTypeInfo);
        Mockito.when((Object)middleTypeInfo.getEnclosingType()).thenReturn((Object)rootTypeInfo);
        Iterator<TypeInfo> iterator = new EnclosingTypeIterable(leafTypeInfo).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)leafTypeInfo));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)middleTypeInfo));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)rootTypeInfo));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
    }
}

