/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.services.MyInterner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CaseInsensitiveSet
extends HashSet<String> {
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof String && super.contains(((String)o).toLowerCase());
    }

    @Override
    public boolean add(String string) {
        return super.add(MyInterner.intern(string.toLowerCase()));
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof String ? Boolean.valueOf(super.remove(((String)o).toLowerCase())) : null;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        boolean retValue = false;
        for (String string : collection) {
            retValue |= this.add(string);
        }
        return retValue;
    }

    public static class Builder {
        private final Set<String> set = new CaseInsensitiveSet();

        public Builder add(String value) {
            this.set.add(value);
            return this;
        }

        public Builder addAll(Collection<String> values) {
            this.set.addAll(values);
            return this;
        }

        public Set<String> build() {
            return Collections.unmodifiableSet(this.set);
        }
    }
}

