/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Result<V> {
    private static final Result<?> NONE = new Result<Object>(null, null);
    private final V value;
    private final String error;

    protected Result(V value, String error) {
        this.value = value;
        this.error = error;
    }

    public static <V> Result<V> of(V value) {
        Preconditions.checkNotNull(value);
        return new Result<V>(value, null);
    }

    public static <V> Result<V> none() {
        return NONE;
    }

    public static <V> Result<V> error(String error) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(error));
        return new Result<Object>(null, error);
    }

    public boolean isPresent() {
        Preconditions.checkState(!this.hasError());
        return this.value != null;
    }

    public boolean absent() {
        Preconditions.checkState(!this.hasError());
        return this.value == null;
    }

    public boolean hasError() {
        return !Strings.isNullOrEmpty(this.error);
    }

    public boolean hasResult() {
        return this.value != null || !Strings.isNullOrEmpty(this.error);
    }

    public V get() {
        Preconditions.checkArgument(this.isPresent());
        return this.value;
    }

    public String getError() {
        Preconditions.checkArgument(this.hasError());
        return this.error;
    }

    public void throwIfError() {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
    }
}

