/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.jorje.semantic.ast.visitor.StackScope;
import apex.jorje.semantic.common.PrintVisitor;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestSymbolProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PrintVisitorTest {
    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"return 1;"}, {"return;"}, {"i.j.k = 1;"}, {"break;"}, {"1++;"}, {"1--;"}, {"-1;"}, {"+1;"}, {"!1;"}, {"~1;"}, {"++1;"}, {"--1;"}, {"(String)1;"}, {"continue;"}, {"a.method();"}, {"method(foo);"}, {"method(a.foo, bar);"}, {"method().i;"}, {"new foo();"}, {"new foo(a, b);"}, {"new foo().i;"}, {"this(10);"}, {"super(10);"}, {"super.i;"}, {"super.method();"}};
    }

    @Test(dataProvider="validData")
    public void testPrinter(String sourceCode) {
        SourceFile source = SourceFile.builder().setBody(sourceCode).build();
        CompilationInput input = new CompilationInput(ImmutableList.of(source), new TestSymbolProvider(), new TestAccessEvaluator(), new TestQueryValidators.Noop(), null);
        ApexCompiler compiler = ApexCompiler.builder().setInput(input).setParserType(ParserWrapper.Type.ANONYMOUS).build();
        List<CodeUnit> codeUnits = compiler.compile();
        CodeUnit codeUnit = codeUnits.stream().findFirst().orElse(null);
        MatcherAssert.assertThat((Object)StackScope.evaluate(codeUnit.getNode(), new PrintVisitor()), (Matcher)Matchers.is((Object)(sourceCode + "\n")));
    }
}

