/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.DottedExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.StackScope;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.PrinterUtil;
import java.util.ArrayDeque;
import java.util.stream.Collectors;

public class PrintVisitor
extends AstVisitor<StackScope<String>> {
    private final PrintContext context;
    private final PrinterFactory printer = PrinterUtil.get().getFactory();

    public PrintVisitor() {
        this.context = new PrintContext();
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(AssignmentExpression node, StackScope<String> scope) {
        String rhs = scope.pop();
        String lhs = scope.pop();
        scope.push(lhs + " = " + rhs);
    }

    @Override
    public boolean visit(LiteralExpression node, StackScope<String> scope) {
        return false;
    }

    @Override
    public void visitEnd(LiteralExpression node, StackScope<String> scope) {
        scope.push(this.printer.literalPrinter().print(node.getLiteralExpr(), this.context));
    }

    @Override
    public void visitEnd(ReferenceExpression node, StackScope<String> scope) {
        String identifiers = node.getJadtIdentifiers().isEmpty() ? "" : this.printer.dottedIdentifier().print(node.getJadtIdentifiers(), this.context) + ".";
        scope.push(scope.pop() + identifiers);
    }

    @Override
    public void visitEnd(MethodCallExpression node, StackScope<String> scope) {
        String methodCallTail = this.getMethodCallTail(scope, node.getInputParameters().size());
        scope.push(scope.pop() + node.getMethodName() + methodCallTail);
    }

    @Override
    public void visitEnd(NewObjectExpression node, StackScope<String> scope) {
        scope.push("new " + node.getMethodName() + this.getMethodCallTail(scope, node.getParameters().size()));
    }

    @Override
    public void visitEnd(PostfixExpression node, StackScope<String> scope) {
        scope.push(scope.pop() + this.printer.postfixOpPrinter().print(node.getOp(), this.context));
    }

    @Override
    public void visitEnd(PrefixExpression node, StackScope<String> scope) {
        scope.push(this.printer.prefixOpPrinter().print(node.getOp(), this.context) + scope.pop());
    }

    @Override
    public void visitEnd(DottedExpression node, StackScope<String> scope) {
        String dottedExpr = node.isNoop() ? "" : scope.pop() + ".";
        scope.push(dottedExpr);
    }

    @Override
    public void visitEnd(VariableExpression node, StackScope<String> scope) {
        scope.push(scope.pop() + node.getIdentifier().value);
    }

    @Override
    public void visitEnd(BreakStatement node, StackScope<String> scope) {
        scope.push("break;\n");
    }

    @Override
    public void visitEnd(ContinueStatement node, StackScope<String> scope) {
        scope.push("continue;\n");
    }

    @Override
    public void visitEnd(ExpressionStatement node, StackScope<String> scope) {
        scope.push(scope.pop() + ";\n");
    }

    @Override
    public boolean visit(ReturnStatement node, StackScope<String> scope) {
        return true;
    }

    @Override
    public void visitEnd(ReturnStatement node, StackScope<String> scope) {
        scope.push(scope.isEmpty() ? "return;\n" : "return " + scope.pop() + ";\n");
    }

    @Override
    public void visitEnd(SuperMethodCallExpression node, StackScope<String> scope) {
        scope.push("super" + this.getMethodCallTail(scope, node.getNumParameters()));
    }

    @Override
    public void visitEnd(ThisMethodCallExpression node, StackScope<String> scope) {
        scope.push("this" + this.getMethodCallTail(scope, node.getNumParameters()));
    }

    @Override
    public void visitEnd(SuperVariableExpression node, StackScope<String> scope) {
        scope.push("super");
    }

    @Override
    public void visitEnd(ThisVariableExpression node, StackScope<String> scope) {
        scope.push("this");
    }

    private String getMethodCallTail(StackScope<String> scope, int numParameters) {
        ArrayDeque<String> params = new ArrayDeque<String>();
        for (int i = 0; i < numParameters; ++i) {
            params.push(scope.pop());
        }
        return params.stream().collect(Collectors.joining(", ", "(", ")"));
    }
}

