/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.SObjectMetadata;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public interface CustomSettingsValidators {

    public static class VisibilityCustomSettingsValidator
    implements BuiltInMethodValidator {
        private static final VisibilityCustomSettingsValidator INSTANCE = new VisibilityCustomSettingsValidator();

        private VisibilityCustomSettingsValidator() {
        }

        public static VisibilityCustomSettingsValidator get() {
            return INSTANCE;
        }

        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    AccessEvaluator accessEvaluator = symbols.getAccessEvaluator();
                    if (!accessEvaluator.isSetupEntityVisibleToType(type, expression.getDefiningType())) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("custom.settings.namespace.not.visible"));
                    }
                    return null;
                }
            });
        }
    }

    public static class GetAllCustomSettingsValidator
    implements BuiltInMethodValidator {
        private static final GetAllCustomSettingsValidator INSTANCE = new GetAllCustomSettingsValidator();

        private GetAllCustomSettingsValidator() {
        }

        public static GetAllCustomSettingsValidator get() {
            return INSTANCE;
        }

        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    StandardCustomSettingsValidator.get().validate(symbols, scope, expression);
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    if (type.getMetadata().isCustomSetting() && type.getMetadata().getCustomSettingType() != SObjectMetadata.CustomSettingType.LIST) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.only.list.custom.settings", type));
                        return null;
                    }
                    return this._default(type);
                }
            });
        }
    }

    public static class StandardCustomSettingsValidator
    implements BuiltInMethodValidator {
        private static final StandardCustomSettingsValidator INSTANCE = new StandardCustomSettingsValidator();

        private StandardCustomSettingsValidator() {
        }

        public static StandardCustomSettingsValidator get() {
            return INSTANCE;
        }

        @Override
        public void validate(final SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
            expression.getMethod().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    VisibilityCustomSettingsValidator.get().validate(symbols, scope, expression);
                    return null;
                }

                @Override
                public Void visit(SObjectTypeInfo type) {
                    if (!type.getMetadata().isCustomSetting()) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("invalid.custom.settings"));
                        return null;
                    }
                    return this._default(type);
                }
            });
        }
    }
}

