/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.validators.CustomSettingsValidators;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.common.iterable.MoreLists;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.MultipleMethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;

public final class SObjectMethods {
    public static final String SOBJECT_METHODS_CLASS_REF = "com/salesforce/api/interop/common/apex/runtime/bytecode/SObjectMethods";

    private SObjectMethods() {
    }

    public static Initializer<MethodTable, TypeInfo> get() {
        return Initializers.memoize(new Initializer<MethodTable, TypeInfo>(){

            private StandardMethodInfoBuilder getInstanceBuilder(TypeInfo type) {
                return StandardMethodInfo.builder().setGenerated(Generated.BUILT_IN).setDefiningType(type).setModifiers(ModifierGroups.GLOBAL);
            }

            private StandardMethodInfoBuilder getStaticBuilder(TypeInfo type) {
                return StandardMethodInfo.builder().setGenerated(Generated.BUILT_IN).setDefiningType(type).setModifiers(ModifierGroups.GLOBAL_STATIC);
            }

            @Override
            public MethodTable get(TypeInfo type) {
                assert (type.getBasicType() == BasicType.SOBJECT);
                ImmutableCollection.Builder builder = ImmutableList.builder().add(new MethodInfo[]{this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("clear").build(), this.getInstanceBuilder(type).setReturnType(type).setName("clone").setEmitSignature("clone", TypeInfos.OBJECT, new TypeInfo[0]).setDuckTyped().build(), this.getInstanceBuilder(type).setReturnType(type).setName("clone").setNamedParameterTypes(TypeInfos.BOOLEAN).setEmitSignature("clone", TypeInfos.OBJECT, TypeInfos.BOOLEAN).setDuckTyped().build(), this.getInstanceBuilder(type).setReturnType(type).setName("clone").setNamedParameterTypes(TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setEmitSignature("clone", TypeInfos.OBJECT, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setDuckTyped().build(), this.getInstanceBuilder(type).setReturnType(type).setName("clone").setNamedParameterTypes(TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setEmitSignature("clone", TypeInfos.OBJECT, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setDuckTyped().build(), this.getInstanceBuilder(type).setReturnType(type).setName("clone").setNamedParameterTypes(TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setEmitSignature("clone", TypeInfos.OBJECT, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN, TypeInfos.BOOLEAN).setDuckTyped().build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.STRING).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.EXCEPTION).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.STRING, TypeInfos.BOOLEAN).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.EXCEPTION, TypeInfos.BOOLEAN).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.STRING, TypeInfos.STRING).setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.DEFAULT_ALLOW_TESTING).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("addError").setNamedParameterTypes(TypeInfos.STRING, TypeInfos.STRING, TypeInfos.BOOLEAN).setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.DEFAULT_ALLOW_TESTING).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("setOptions").setNamedParameterTypes(InternalTypeInfos.DATABASE_DML_OPTIONS).setEmitSignature("setOptions", TypeInfos.VOID, TypeInfos.OBJECT).build(), this.getInstanceBuilder(type).setReturnType(InternalTypeInfos.DATABASE_DML_OPTIONS).setName("getOptions").build(), this.getInstanceBuilder(type).setReturnType(ReifiedTypeInfos.STRING_TO_ID_MAP).setName("getActiveRecordTypesByName").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowPrivate().setAllowTrustedApplications().build()).build(), this.getInstanceBuilder(type).setReturnType(ReifiedTypeInfos.ID_TO_STRING_MAP).setName("getActiveRecordTypes").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowPrivate().setAllowTrustedApplications().build()).build(), this.getInstanceBuilder(type).setReturnType(ReifiedTypeInfos.STRING_SET).setName("getDifferingFields").setNamedParameterTypes(type).setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowPrivate().build()).build(), this.getInstanceBuilder(type).setReturnType(InternalTypeInfos.SCHEMA_SOBJECT_TYPE).setName("getSObjectType").build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.OBJECT).setName("get").setNamedParameterTypes(TypeInfos.STRING).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.OBJECT).setName("get").setNamedParameterTypes(InternalTypeInfos.SCHEMA_SOBJECT_FIELD).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("getSObject").setNamedParameterTypes(TypeInfos.STRING).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("getSObject").setNamedParameterTypes(InternalTypeInfos.SCHEMA_SOBJECT_FIELD).build(), this.getInstanceBuilder(type).setReturnType(ReifiedTypeInfos.SOBJECT_LIST).setName("getSObjects").setNamedParameterTypes(TypeInfos.STRING).build(), this.getInstanceBuilder(type).setReturnType(ReifiedTypeInfos.SOBJECT_LIST).setName("getSObjects").setNamedParameterTypes(InternalTypeInfos.SCHEMA_SOBJECT_FIELD).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.OBJECT).setName("put").setNamedParameterTypes(TypeInfos.STRING, TypeInfos.OBJECT).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.OBJECT).setName("put").setNamedParameterTypes(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, TypeInfos.OBJECT).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("putSObject").setNamedParameterTypes(TypeInfos.STRING, TypeInfos.SOBJECT).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("putSObject").setNamedParameterTypes(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, TypeInfos.SOBJECT).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.STRING).setName("getQuickActionName").build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.BOOLEAN).setName("isClone").setNamedParameterTypes(new TypeInfo[0]).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.ID).setName("getCloneSourceId").setNamedParameterTypes(new TypeInfo[0]).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.VOID).setName("recalculateFormulas").build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("getSObjectsSelectLoop").setNamedParameterTypes(TypeInfos.OBJECT).setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowInternalSfdc().setAllowInApexFiles().build()).build(), this.getInstanceBuilder(type).setReturnType(TypeInfos.SOBJECT).setName("getSObjectsSelectLoop").setNamedParameterTypes(TypeInfos.STRING).setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowInternalSfdc().setAllowInApexFiles().build()).build()});
                if (!TypeInfoEquivalence.isEquivalent(type, TypeInfos.SOBJECT)) {
                    ((ImmutableList.Builder)builder).add(new MethodInfo[]{this.getStaticBuilder(type).setReturnType(type).setName("getInstance").setNamedParameterTypes(TypeInfos.STRING).setValidators(CustomSettingsValidators.StandardCustomSettingsValidator.get()).build(), this.getStaticBuilder(type).setReturnType(type).setName("getInstance").setNamedParameterTypes(TypeInfos.ID).setValidators(CustomSettingsValidators.StandardCustomSettingsValidator.get()).build(), this.getStaticBuilder(type).setReturnType(type).setName("getInstance").setNamedParameterTypes(new TypeInfo[0]).setValidators(CustomSettingsValidators.StandardCustomSettingsValidator.get()).build(), this.getStaticBuilder(type).setReturnType(type).setName("getValues").setNamedParameterTypes(TypeInfos.STRING).build(), this.getStaticBuilder(type).setReturnType(type).setName("getValues").setNamedParameterTypes(TypeInfos.ID).build(), this.getStaticBuilder(type).setReturnType(type).setName("getOrgDefaults").setNamedParameterTypes(new TypeInfo[0]).setValidators(CustomSettingsValidators.StandardCustomSettingsValidator.get()).build(), this.getStaticBuilder(type).setReturnType(GenericTypeInfoFactory.createMap(TypeInfos.STRING, type)).setName("getAll").setNamedParameterTypes(new TypeInfo[0]).setValidators(CustomSettingsValidators.GetAllCustomSettingsValidator.get()).build(), this.getStaticBuilder(type).setReturnType(InternalTypeInfos.SCHEMA_SOBJECT_TYPE).setName("getSObjectType").setNamedParameterTypes(new TypeInfo[0]).build()});
                }
                return MethodTableFactory.create(new MultipleMethodTable(), ((ImmutableList.Builder)builder).build());
            }
        });
    }

    public static AsmMethod getSObjectsSelectLoop(TypeInfo type) {
        assert (type == TypeInfos.STRING || type == TypeInfos.OBJECT);
        return AsmMethod.builder().invokeStatic().setDefiningTypeAsBytecodeMethodName(InternalTypeInfos.SOBJECT_METHODS).setFunction("getSObjectsSelectLoop").setSignature((TypeInfo)TypeInfos.OBJECT, TypeInfos.SOBJECT, type).build();
    }

    public static AsmMethod mapToStatic(MethodInfo method) {
        if (method.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return method.getAsmMethod();
        }
        Signature emitSignature = method.getEmitSignature();
        return AsmMethod.builder().setOpcode(184).setDefiningTypeAsBytecodeMethodName(InternalTypeInfos.SOBJECT_METHODS).setFunction(method.getMangledCanonicalName()).setSignature(SignatureFactory.create(method.getMangledCanonicalName(), emitSignature.getReturnType(), MoreLists.concat(TypeInfos.SOBJECT, emitSignature.getParameterTypes()))).build();
    }

    public static AsmMethod initializationCompleted(TypeInfo type) {
        return AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeMethodName(type).setFunction("initializationCompleted").setSignature((TypeInfo)TypeInfos.VOID, new TypeInfo[0]).build();
    }

    public static AsmMethod addErrorOne() {
        return AsmMethod.builder().invokeStatic().setDefiningTypeAsBytecodeMethodName(InternalTypeInfos.SOBJECT_METHODS).setFunction("addError").setSignature((TypeInfo)TypeInfos.VOID, TypeInfos.SOBJECT, TypeInfos.STRING, TypeInfos.STRING).build();
    }

    public static AsmMethod addErrorTwo() {
        return AsmMethod.builder().invokeStatic().setDefiningTypeAsBytecodeMethodName(InternalTypeInfos.SOBJECT_METHODS).setFunction("addError").setSignature((TypeInfo)TypeInfos.VOID, TypeInfos.SOBJECT, TypeInfos.STRING, TypeInfos.STRING, TypeInfos.BOOLEAN).build();
    }
}

