/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.ast.visitor.reference.ReferencedTypeVisitor;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestFlowInterviewTypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.matchers.IterableMatchers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReferencedTypeVisitorTest {
    private static final GenericTypeInfo FOO_OF_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyClass((String)"Foo"))).setTypeArguments(ArgumentTypeInfos.T).buildResolved();
    private static final GenericTypeInfo BAR_OF_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyClass((String)"Bar"))).buildResolved();
    private static final ReferencedTypeVisitor REFERENCED_TYPE_VISITOR = new ReferencedTypeVisitor();

    @DataProvider
    Object[][] referencesData() {
        return new Object[][]{{GenericTypeInfoFactory.createList(TestSObjectTypeInfos.ACCOUNT), ImmutableList.of(TestSObjectTypeInfos.ACCOUNT)}, {GenericTypeInfoFactory.createListIterator(TestSObjectTypeInfos.ACCOUNT), ImmutableList.of(TestSObjectTypeInfos.ACCOUNT)}, {GenericTypeInfoFactory.createSet(TestSObjectTypeInfos.ACCOUNT), ImmutableList.of(TestSObjectTypeInfos.ACCOUNT)}, {GenericTypeInfoFactory.createMap(TestSObjectTypeInfos.ACCOUNT, TestSObjectTypeInfos.CONTACT), ImmutableList.of(TestSObjectTypeInfos.ACCOUNT, TestSObjectTypeInfos.CONTACT)}, {GenericTypeInfoFactory.create((TypeInfo)FOO_OF_T, TypeInfos.STRING), ImmutableList.of(FOO_OF_T)}, {GenericTypeInfoFactory.create((TypeInfo)FOO_OF_T, TestSObjectTypeInfos.ACCOUNT), ImmutableList.of(FOO_OF_T, TestSObjectTypeInfos.ACCOUNT)}, {GenericTypeInfoFactory.create((TypeInfo)FOO_OF_T, GenericTypeInfoFactory.create((TypeInfo)BAR_OF_T, TypeInfos.STRING)), ImmutableList.of(FOO_OF_T, BAR_OF_T)}, {TestStandardTypeInfos.SYSTEM_PAGE, ImmutableList.of(TestStandardTypeInfos.SYSTEM_PAGE)}, {TestStandardTypeInfos.SYSTEM_LABEL, ImmutableList.of(TestStandardTypeInfos.SYSTEM_LABEL)}, {TestFlowInterviewTypeInfos.THE_FLOW, ImmutableList.of(TestFlowInterviewTypeInfos.THE_FLOW)}};
    }

    @Test(dataProvider="referencesData")
    public void testReferences(TypeInfo type, List<TypeInfo> expectedReferences) {
        List<TypeInfo> actualReferences = type.accept(REFERENCED_TYPE_VISITOR);
        MatcherAssert.assertThat(actualReferences, IterableMatchers.containsInAnyOrder(expectedReferences));
    }

    @DataProvider
    Object[][] noReferencesData() {
        return new Object[][]{{InternalTypeInfos.SYSTEM_ITERATOR}, {ReifiedTypeInfos.STRING_LIST}, {ReifiedTypeInfos.STRING_SET}, {ReifiedTypeInfos.STRING_TO_STRING_MAP}, {TypeInfos.STRING}, {InternalTypeInfos.APEX_PAGES_COMPONENT}};
    }

    @Test(dataProvider="noReferencesData")
    public void testNoReferences(TypeInfo type) {
        List<TypeInfo> actualReferences = type.accept(REFERENCED_TYPE_VISITOR);
        MatcherAssert.assertThat(actualReferences, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

