/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.semantic.symbol.type.FlowInterviewTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ReferencedTypeVisitor
extends TypeInfoVisitor.Default<List<TypeInfo>> {
    ReferencedTypeVisitor() {
    }

    @Override
    protected List<TypeInfo> _default(TypeInfo type) {
        return Collections.emptyList();
    }

    @Override
    public List<TypeInfo> visit(StandardTypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.SYSTEM_PAGE) || TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.SYSTEM_LABEL) || type.getCodeUnitDetails().isApexSourceBased() ? Collections.singletonList(type) : Collections.emptyList();
    }

    @Override
    public List<TypeInfo> visit(GenericTypeInfo type) {
        ArrayList<TypeInfo> referredTypes = Lists.newArrayList();
        switch (type.getBasicType()) {
            case LIST: 
            case SET: 
            case MAP: {
                for (TypeInfo typeInfo : type.getTypeArguments()) {
                    referredTypes.addAll((Collection<TypeInfo>)typeInfo.accept(this));
                }
                return referredTypes;
            }
            case APEX_OBJECT: {
                TypeInfo rootUnreifiedType = type.getRootUnreifiedType();
                if (!rootUnreifiedType.getCodeUnitDetails().isFileBased()) {
                    referredTypes.add(rootUnreifiedType);
                    for (TypeInfo argumentTypeInfo : type.getTypeArguments()) {
                        referredTypes.addAll((Collection<TypeInfo>)argumentTypeInfo.accept(this));
                    }
                    return referredTypes;
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<TypeInfo> visit(SObjectTypeInfo type) {
        return Collections.singletonList(type);
    }

    @Override
    public List<TypeInfo> visit(FlowInterviewTypeInfo type) {
        return Collections.singletonList(type);
    }
}

