/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.compilation.ConstructorPreamble;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;

public class SymbolScope
extends Scope {
    private final SymbolResolver symbols;
    private final Errors errors;

    public SymbolScope(SymbolResolver symbols, Errors errors) {
        this.symbols = symbols;
        this.errors = errors;
    }

    public static SymbolScope create(CompilerContext context, CodeUnit codeUnit) {
        return new SymbolScope(context.getSymbolResolver(), codeUnit.getErrors());
    }

    @Override
    public void push(BlockStatement node) {
        this.symbols.variables().push(node.getLocals());
    }

    @Override
    public void pop(BlockStatement node) {
        this.symbols.variables().pop();
    }

    @Override
    public void push(ForEachStatement node) {
        this.symbols.variables().push(node.getLocals());
    }

    @Override
    public void pop(ForEachStatement node) {
        this.symbols.variables().pop();
    }

    @Override
    public void push(ForLoopStatement node) {
        this.symbols.variables().push(node.getLocals());
    }

    @Override
    public void pop(ForLoopStatement node) {
        this.symbols.variables().pop();
    }

    @Override
    public void push(CatchBlockStatement node) {
        this.symbols.variables().push(node.getLocals());
    }

    @Override
    public void pop(CatchBlockStatement node) {
        this.symbols.variables().pop();
    }

    @Override
    public void push(Field node) {
        this.symbols.staticContext().set(node.getModifierInfo().has(ModifierTypeInfos.STATIC));
    }

    @Override
    public void pop(Field node) {
        this.symbols.staticContext().clear();
    }

    @Override
    public void push(Method node) {
        assert (this.symbols.variables().numberOfScopes() == 0);
        this.symbols.variables().push(node.getLocals());
        ModifierGroup modifiers = node.getModifiers();
        this.symbols.staticContext().set(modifiers.has(ModifierTypeInfos.STATIC));
    }

    @Override
    public void pop(Method node) {
        this.symbols.variables().pop();
        this.symbols.staticContext().clear();
        assert (this.symbols.variables().numberOfScopes() == 0);
    }

    @Override
    public void push(ConstructorPreamble node) {
        this.symbols.staticContext().set(false);
    }

    @Override
    public void pop(ConstructorPreamble node) {
        this.symbols.staticContext().clear();
    }

    public SymbolResolver getSymbols() {
        return this.symbols;
    }

    public Errors getErrors() {
        return this.errors;
    }
}

