/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserClassMethods;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;

public class MemberResolveVisitor
extends AstVisitor<SymbolScope> {
    @Override
    public boolean visit(AnonymousClass node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(AnonymousClass node, SymbolScope scope) {
        this.visitEndCompilation(node);
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, SymbolScope scope) {
        this.visitEndCompilation(node);
    }

    @Override
    public boolean visit(UserEnum node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserEnum node, SymbolScope scope) {
        this.visitEndCompilation(node);
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserInterface node, SymbolScope scope) {
        this.visitEndCompilation(node);
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserTrigger node, SymbolScope scope) {
        this.visitEndCompilation(node);
    }

    @Override
    public boolean visit(Property node, SymbolScope scope) {
        node.resolve(scope.getSymbols());
        return true;
    }

    @Override
    public void visitEnd(Property node, SymbolScope scope) {
        TypeInfo definingType = node.getDefiningType();
        scope.getErrors().addIfError((AstNode)node, node.getFieldInfo().getLoc(), definingType.fields().add(node.getFieldInfo()));
    }

    @Override
    public boolean visit(Field node, SymbolScope scope) {
        node.resolve(scope.getSymbols());
        return true;
    }

    @Override
    public void visitEnd(Field node, SymbolScope scope) {
        TypeInfo definingType = node.getDefiningType();
        if (!scope.getErrors().isInvalid((AstNode)node) && !node.getFieldInfo().getModifiers().has(ModifierTypeInfos.HIDDEN)) {
            scope.getErrors().addIfError((AstNode)node, node.getFieldInfo().getLoc(), definingType.fields().add(node.getFieldInfo()));
        }
    }

    @Override
    public boolean visit(Parameter node, SymbolScope scope) {
        node.resolve(scope.getSymbols());
        return true;
    }

    @Override
    public boolean visit(Method node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(Method node, SymbolScope scope) {
        node.resolve(scope.getSymbols());
        TypeInfo definingType = node.getDefiningType();
        if (!node.getMethodInfo().getReturnType().isResolved()) {
            assert (node.getReturnTypeRef() != TypeReferences.GENERATED_TYPE_REF) : "If we couldn't resolve it then it should have had a type ref. Internal types are the only types that should be missing typeRefs.";
            scope.getErrors().markInvalid((AstNode)node, UnresolvedErrorCalculator.getErrors(node.getMethodInfo().getReturnType()));
        }
        if (!scope.getErrors().isInvalid((AstNode)node) && !node.getMethodInfo().getGenerated().isInternal) {
            scope.getErrors().addIfError(node, definingType.methods().addNoDuplicatesAllowed(node.getMethodInfo()));
        }
    }

    @Override
    public boolean visit(UserClassMethods node, SymbolScope scope) {
        node.createMethods();
        return true;
    }

    @Override
    public boolean visit(UserExceptionMethods node, SymbolScope scope) {
        node.createMethods(scope);
        return true;
    }

    @Override
    public void visitEnd(ModifierNode node, SymbolScope scope) {
        node.resolve();
    }

    private void visitEndCompilation(Compilation node) {
        node.getDefiningType().fields().resolve();
        node.getDefiningType().methods().resolve();
    }
}

