/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.DeclarationStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import java.util.List;

public class VariableDeclarationStatements
extends Statement
implements DeclarationStatement {
    private final TypeRef typeRef;
    private final Loc loc;
    private final List<VariableDeclaration> declarations;
    private final ModifierGroup modifierInfo;
    private final ModifierNode modifiers;
    private TypeInfo type;

    public VariableDeclarationStatements(AstNode definingNode, Stmnt.VariableDeclStmnt stmnt) {
        super(definingNode);
        this.typeRef = stmnt.variableDecls.type;
        this.loc = Location.from(stmnt);
        this.modifierInfo = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(stmnt.variableDecls.modifiers).build();
        this.declarations = stmnt.variableDecls.decls.stream().filter(AstNodeFactory.VARIABLE_DECLS_FILTER::apply).map(variable -> new VariableDeclaration(this, (VariableDecl)variable)).collect(MoreIterables.toUnmodifiableList(stmnt.variableDecls.decls.size()));
        this.modifiers = new ModifierNode(this, this.modifierInfo);
    }

    public TypeRef getTypeName() {
        return this.typeRef;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.modifiers.traverse(visitor, scope);
            for (VariableDeclaration declaration : this.declarations) {
                declaration.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (this.type.equals(TypeInfos.VOID) && Version.V168.isLessThanOrEqual(VersionUtil.get(this))) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.void.variable"));
            return;
        }
        if (!Visibility.isTypeSfdcOnlyVisibleFromCurrentType(symbols, this.getDefiningType(), this.type) || !Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, scope.isTestMethod())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        this.modifiers.validate(symbols, scope);
        for (VariableDeclaration declaration : this.declarations) {
            declaration.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        for (VariableDeclaration declaration : this.declarations) {
            declaration.emit(emitter);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    @Override
    public TypeInfo getType() {
        assert (this.type != null);
        return this.type;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifierInfo;
    }

    public void resolveType(SymbolResolver symbols) {
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
    }
}

