/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;
import java.util.Optional;

public class VariableDeclaration
extends Statement {
    private final Identifier name;
    private final Expression store;
    private final Expression assignment;
    private final VariableDeclarationStatements declarations;
    private LocalInfo localInfo;

    public VariableDeclaration(VariableDeclarationStatements declarations, VariableDecl variable) {
        super(declarations);
        this.declarations = declarations;
        this.name = variable.name;
        Expr.VariableExpr expr = JadtFactory.variableExpr(Optional.empty(), variable.name);
        this.store = AstNodeFactory.createStore(this, expr);
        this.assignment = variable.assignment.map(value -> AstNodeFactory.create((AstNode)this, value)).orElse(Expression.NOOP);
    }

    public TypeRef getTypeNameUsed() {
        return this.declarations.getTypeName();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            if (scope instanceof SymbolScope) {
                SymbolResolver symbols = ((SymbolScope)scope).getSymbols();
                symbols.variables().peek().setDeclaration(this.localInfo);
                this.assignment.traverse(visitor, scope);
                symbols.variables().peek().clearDeclaration();
            } else {
                this.assignment.traverse(visitor, scope);
            }
            this.store.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.store.getOptions().isInitialStore = true;
        symbols.variables().peek().setDeclaration(this.localInfo);
        this.assignment.validate(symbols, scope);
        symbols.variables().peek().clearDeclaration();
        this.store.validate(symbols, scope);
        scope.getErrors().addIfError((AstNode)this, this.name.loc, IdentifierValidator.get().validate(this.getDefiningType(), this.name, IdentifierValidator.Type.VARIABLE, false));
        if (scope.getErrors().isInvalid(this.assignment, this.store)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.assignment != Expression.NOOP && !Distance.get().canAssign(this.getDefiningType(), this.assignment.getType(), this.declarations.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.assignment", this.assignment.getType(), this.declarations.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.localInfo.getLoc(), true, false);
        if (this.assignment != Expression.NOOP) {
            this.assignment.emit(emitter);
            TypeConversion.emitOrCheckCast(this.localInfo.getLoc(), emitter, this.assignment.getType(), this.localInfo.getType());
        } else {
            emitter.emit(this.localInfo.getLoc(), 1);
        }
        this.store.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.localInfo.getLoc();
    }

    public void createLocal(SymbolScope scope) {
        ModifierGroup myModifiers = this.declarations.getModifiers().copy().setLoc(this.name.loc).build().resolve();
        this.localInfo = LocalInfo.builder().setName(this.name).setDefiningType(this.getDefiningType()).setType(this.declarations.getType()).setModifiers(myModifiers).build();
        scope.getErrors().addIfError((AstNode)this, this.name.loc, scope.getSymbols().variables().add(this.localInfo));
    }

    public LocalInfo getLocalInfo() {
        return this.localInfo;
    }
}

