/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;

public class StatementExecuted
extends SimpleStatement {
    private final Loc executedLoc;
    private final Loc statementLoc;
    private final boolean zeroStatements;
    private final boolean trackCodeCoverage;

    private StatementExecuted(AstNode definingNode, Loc executedLoc, Loc statementLoc, boolean zeroStatements, boolean trackCodeCoverage) {
        super(definingNode);
        this.executedLoc = executedLoc;
        this.statementLoc = statementLoc;
        this.zeroStatements = zeroStatements;
        this.trackCodeCoverage = trackCodeCoverage;
    }

    public static Statement createSynthetic(AstNode definingNode, Loc loc, boolean zeroStatements, boolean trackCodeCoverage) {
        return new StatementExecuted(definingNode, loc, Loc._SyntheticLoc(), zeroStatements, trackCodeCoverage);
    }

    public static Statement createReal(AstNode definingNode, Loc loc, boolean zeroStatements, boolean trackCodeCoverage) {
        return new StatementExecuted(definingNode, loc, loc, zeroStatements, trackCodeCoverage);
    }

    @Override
    public Loc getLoc() {
        return this.statementLoc;
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.executedLoc, this.zeroStatements, this.trackCodeCoverage);
    }
}

