/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.ConstructorPreambleStatement;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.EmitScope;
import apex.jorje.semantic.ast.visitor.InitializeUseBeforeDefinedVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.Version;
import com.google.common.collect.Iterables;

public class MethodBlockStatement
extends Statement {
    private final Statement root;
    private Statement preamble;

    public MethodBlockStatement(AstNode definingNode, Statement root) {
        super(definingNode);
        this.root = root;
    }

    private static Statement get(final AstNode definingNode, MethodInfo method, Statement root) {
        assert (!method.isStaticInitialization() || !method.isConstructor()) : "method cannot be both clinit and init";
        if (method.isStaticInitialization() && method.getDefiningType().getUnitType() == UnitType.CLASS) {
            return new SimpleStatement(definingNode){

                @Override
                public void emit(Emitter emitter) {
                    StatementExecuted.createSynthetic(definingNode, emitter.getTypeStack().peek().getLoc(), false, false).emit(emitter);
                }
            };
        }
        if (method.isConstructor() && method.getGenerated().isUserDefined) {
            return new ConstructorPreambleStatement(definingNode, method.getLoc(), root);
        }
        return Statement.NOOP;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        this.root.traverse(visitor, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.preamble = MethodBlockStatement.get(this, scope.getMethod(), this.root);
        this.root.validate(symbols, scope);
        this.preamble.validate(symbols, scope);
        this.setReturnable(this.root.isReturnable());
        if (scope.getErrors().isInvalid(this.root, this.preamble)) {
            scope.getErrors().markInvalid(this);
        }
    }

    public boolean hasBody() {
        return this.root != Statement.NOOP;
    }

    public boolean isLastStatementReturn() {
        return this.hasBody() && ValueScope.evaluate(this.root, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            protected boolean defaultVisit() {
                return MethodBlockStatement.this.root.isReturnable();
            }

            @Override
            public boolean visit(BlockStatement node, ValueScope<Boolean> scope) {
                if (!node.getStatements().isEmpty()) {
                    scope.setValue(Iterables.getLast(node.getStatements()).isReturnable());
                }
                return true;
            }
        }, this.root.isReturnable()) != false;
    }

    @Override
    public Loc getLoc() {
        return this.root.getLoc();
    }

    @Override
    public void emit(Emitter emitter) {
        this.preamble.emit(emitter);
        if (Version.V174.isGreaterThanOrEqual(this.getDefiningType().getCodeUnitDetails().getVersion())) {
            this.root.traverse(new InitializeUseBeforeDefinedVisitor(), new EmitScope(emitter));
        }
        this.root.emit(emitter);
    }
}

