/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.Location;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class IfElseBlockStatement
extends Statement {
    private final List<IfBlockStatement> ifBlockStatements;
    private final Statement elseStatement;
    private final Loc loc;
    private final Iterable<Statement> statements;
    private Label exit;

    public IfElseBlockStatement(AstNode definingNode, Stmnt.IfElseBlock stmnt) {
        super(definingNode);
        this.loc = Location.from(stmnt);
        this.ifBlockStatements = MoreIterables.filterNullTransform(stmnt.ifBlocks, ifBlock -> new IfBlockStatement(this, (IfBlock)ifBlock));
        this.elseStatement = stmnt.elseBlock.map(value -> AstNodeFactory.create((AstNode)this, value.stmnt)).orElse(NOOP);
        this.statements = Iterables.concat(this.ifBlockStatements, Collections.singletonList(this.elseStatement));
        this.setReturnable(this.statements);
        this.exit = new Label();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Statement statement : this.statements) {
                statement.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (Statement statement : this.statements) {
            statement.validate(symbols, scope);
        }
        if (scope.getErrors().isInvalid(this.ifBlockStatements, this.elseStatement)) {
            scope.getErrors().markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        for (IfBlockStatement ifBlockStatement : this.ifBlockStatements) {
            ifBlockStatement.emit(emitter);
        }
        this.elseStatement.emit(emitter);
        if (this.elseStatement == NOOP) {
            emitter.emitStatementExecuted(this.loc, true, true);
        }
        emitter.emit(this.exit);
        this.exit = new Label();
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public Label getExit() {
        return this.exit;
    }
}

