/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.TopLevel;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;

public class ExpressionStatement
extends Statement {
    private final Expression expression;
    private final Loc loc;
    private final boolean canBeTopLevel;

    public ExpressionStatement(AstNode definingNode, Stmnt.ExpressionStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.canBeTopLevel = TopLevel.canBeTopLevel(stmnt.expr);
        this.expression = AstNodeFactory.create((AstNode)this, stmnt.expr);
        this.expression.setTopLevel();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        this.setConstructorCall(this.expression.getConstructorCall());
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!this.canBeTopLevel) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.expression.statement"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.expression.getLoc(), true, false);
        this.expression.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

