/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import shaded.org.objectweb.asm.Label;

public class DoLoopStatement
extends Statement {
    private final Condition condition;
    private final Statement bodyStatement;
    private final Loc loc;

    public DoLoopStatement(AstNode definingNode, Stmnt.DoLoop stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.condition = new StandardCondition(this, stmnt.condition);
        this.bodyStatement = AstNodeFactory.create((AstNode)this, stmnt.stmnt);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.bodyStatement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            this.condition.validate(symbols, scope);
            this.bodyStatement.validate(symbols, scope);
            if (scope.getErrors().isInvalid(this.condition, this.bodyStatement)) {
                scope.getErrors().markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        LoopStack loopStack = emitter.getLoopStack();
        LoopStack.LoopContext loop = new LoopStack.LoopContext(emitter, this.bodyStatement.getLoc(), this.getLoc());
        loop.setTryStackSize();
        loopStack.push(loop);
        Label start = new Label();
        emitter.emit(start);
        this.bodyStatement.traverse(new AstVisitor<Scope>(){

            @Override
            public boolean visit(BlockStatement node, Scope scope) {
                Loc loc = node.getStatements().isEmpty() ? node.getLoc() : node.getStatements().get(0).getLoc();
                emitter.emit(loc, 0);
                return false;
            }
        }, NoopScope.get());
        this.bodyStatement.emit(emitter);
        loop.emitContinueLabel();
        Label falseLabel = this.condition.getFalseLabel(emitter);
        emitter.emitJump(this.condition.getLoc(), 167, start);
        emitter.emit(falseLabel);
        LoopStack.LoopContext sanity = loopStack.pop();
        assert (loop == sanity);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

