/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseMethods;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import java.util.Optional;

public class DmlUpsertStatement
extends Statement {
    private static final DmlOperation OP = DmlOperation.UPSERT;
    private final Loc loc;
    private final Expression expression;
    private final Optional<FieldIdentifier> fieldIdentifier;
    private Optional<FieldInfo> fieldIdentifierFieldInfo;

    public DmlUpsertStatement(AstNode definingNode, Stmnt.DmlUpsertStmnt x) {
        super(definingNode);
        this.loc = x.loc;
        this.expression = AstNodeFactory.create((AstNode)this, x.expr);
        this.fieldIdentifier = x.id;
    }

    private static String buildFieldName(TypeInfo type, String fieldName) {
        if (Namespace.isEmptyOrNull(type.getNamespace())) {
            return fieldName;
        }
        return SObjectTypeInfoUtil.isQualifiedField(type.getNamespace(), fieldName) ? fieldName : type.getNamespace() + "__" + fieldName;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.expression.getType().getBasicType() != BasicType.SOBJECT && !SObjectTypeInfoUtil.isSObjectList(this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.dml.type", this.expression.getType()));
            return;
        }
        if (!SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.INSERT, this.expression.getType()) && !SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.UPDATE, this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("dml.not.allowed", this.expression.getType()));
            return;
        }
        if (!SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.UPSERT, this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("dml.operation.not.allowed", DmlOperation.UPSERT.getApexName(), this.expression.getType()));
            return;
        }
        this.fieldIdentifier.ifPresent(value -> {
            TypeInfo typeToValidate;
            TypeInfo typeInfo = typeToValidate = SObjectTypeInfoUtil.isConcreteSObjectList(this.expression.getType()) ? CollectionTypeInfoUtil.getElementType(this.expression.getType()) : this.expression.getType();
            if (!SObjectTypeInfoUtil.isConcreteSObject(typeToValidate)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("upsert.requires.concrete.type"));
                return;
            }
            if (!SObjectTypeInfoUtil.isLookupField(typeToValidate, value.field.value)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("upsert.invalid.field", PrinterUtil.get().getFactory().fieldIdentifierPrinter().print((FieldIdentifier)value, new PrintContext())));
                return;
            }
            this.fieldIdentifierFieldInfo = Optional.of(typeToValidate.fields().get(symbols, this.getDefiningType(), value.field.value, false));
        });
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.loc, true, false);
        this.expression.emit(emitter);
        this.fieldIdentifier.map(value -> innerEmitter -> {
            TypeInfo type = TypeInfoUtil.peelType(this.expression.getType());
            String fieldName = this.fieldIdentifierFieldInfo.map(Member::getName).orElse(value.field.value);
            innerEmitter.push(this.loc, type.getApexName());
            innerEmitter.push(this.loc, DmlUpsertStatement.buildFieldName(type, fieldName));
            innerEmitter.push(this.loc, type.getNamespace().getGlobal());
        }).orElseGet(() -> innerEmitter -> {
            innerEmitter.emit(this.loc, 1);
            innerEmitter.emit(this.loc, 1);
            innerEmitter.emit(this.loc, 1);
        }).emit(emitter);
        ProfilingType.DML.emit(emitter, this.loc, OP.getName(this.expression.getType()));
        emitter.emit(this.loc, CollectionTypeInfoUtil.isList(this.expression.getType()) ? DatabaseMethods.dmlUpsertList() : DatabaseMethods.dmlUpsert());
        emitter.emit(this.loc, 87);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Optional<FieldIdentifier> getFieldIdentifier() {
        return this.fieldIdentifier;
    }
}

