/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.ConstructorCall;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;

public class BlockStatement
extends Statement {
    private final List<Statement> statements;
    private final Loc loc;
    private final LocalVariableScope locals;

    public BlockStatement(AstNode definingNode, Stmnt.BlockStmnt stmnt) {
        super(definingNode);
        this.loc = Location.from(stmnt);
        this.statements = AstNodeFactory.createStatements(this, stmnt.stmnts);
        this.locals = new LocalVariableScope();
        this.setReturnable(MoreIterables.ensureAny(this.statements, Statement::isReturnable));
    }

    private static UnreachableStatementChecker createUnreachableStatementChecker(Statement node) {
        Version version = VersionUtil.get(node);
        if (version.isLessThanOrEqual(Version.V200)) {
            return version.isLessThanOrEqual(Version.V146) || !node.isReturnable() ? new Noop() : new OldAndBusted();
        }
        return new AsGoodAsJava();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            for (Statement statement : this.statements) {
                statement.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            for (Statement statement : this.statements) {
                statement.validate(symbols, scope);
                if (scope.isFirstStatementInBlock()) {
                    this.setConstructorCall(statement.getConstructorCall());
                }
                scope.incrementBlock();
            }
            BlockStatement.createUnreachableStatementChecker(this).check(scope, this.statements);
            if (scope.getErrors().isInvalid(this.statements)) {
                scope.getErrors().markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        List statements = this.statements.stream().filter(statement -> statement.getConstructorCall() == ConstructorCall.NONE).collect(MoreIterables.toUnmodifiableList(this.statements.size()));
        emitter.emitStatementExecuted(this.loc, statements.isEmpty(), false);
        for (Statement statement2 : statements) {
            statement2.emit(emitter);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public void emit(Emitter emitter, int index) {
        Preconditions.checkElementIndex(index, this.statements.size());
        this.statements.get(index).emit(emitter);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    private static class AsGoodAsJava
    implements UnreachableStatementChecker {
        private AsGoodAsJava() {
        }

        @Override
        public void check(ValidationScope scope, List<Statement> statements) {
            for (int i = 0; i < statements.size() - 1; ++i) {
                if (!statements.get(i).isReturnable()) continue;
                scope.getErrors().markInvalid((AstNode)statements.get(i + 1), I18nSupport.getLabel("unreachable.statement"));
                break;
            }
        }
    }

    private static class OldAndBusted
    implements UnreachableStatementChecker {
        private OldAndBusted() {
        }

        @Override
        public void check(ValidationScope scope, List<Statement> statements) {
            Statement lastStatement;
            if (!scope.isOutsideMethod() && scope.getMethod().hasReturnValue() && scope.isTopLevelBlock() && !statements.isEmpty() && !(lastStatement = Iterables.getLast(statements)).isReturnable()) {
                scope.getErrors().markInvalid((AstNode)lastStatement, I18nSupport.getLabel("unreachable.statement"));
            }
        }
    }

    private static class Noop
    implements UnreachableStatementChecker {
        private Noop() {
        }

        @Override
        public void check(ValidationScope scope, List<Statement> statements) {
        }
    }

    private static interface UnreachableStatementChecker {
        public void check(ValidationScope var1, List<Statement> var2);
    }
}

