/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class TestContextRule
implements AnnotationContextRule {
    private static final TestContextRule INSTANCE = new TestContextRule();

    private TestContextRule() {
    }

    public static TestContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        MethodInfo method = context.getMethodInfo();
        if (!method.getParameters().isEmpty()) {
            context.addNodeError(I18nSupport.getLabel("test.method.cannot.have.params"));
        }
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        if (ExceptionTypeInfoUtil.isException(context.getVersion(), context.getDefiningType())) {
            context.addNodeError(I18nSupport.getLabel("test.class.must.not.be.exception"));
        }
    }
}

