/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.WrapperTypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class RemoteActionContextRule
implements AnnotationContextRule {
    private static final RemoteActionContextRule INSTANCE = new RemoteActionContextRule();

    private RemoteActionContextRule() {
    }

    public static RemoteActionContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        if (context.getModifiers().has(ModifierTypeInfos.PUBLIC) && context.getSymbols().getAccessEvaluator().isGlobalComponent(context.getDefiningType())) {
            context.addNodeError(I18nSupport.getLabel("invalid.public.remote.action"));
        }
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.REMOTE_ACTION, new ParameterTypeVisitor(context.getSymbols().getAccessEvaluator()), new ReturnTypeVisitor(context.getSymbols().getAccessEvaluator()));
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }

    private static class ParameterTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final AccessEvaluator evaluator;

        private ParameterTypeVisitor(AccessEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return !AnnotationRuleUtil.isConnectApiAndNotBatchResult(type) || !AnnotationRuleUtil.hasConnectDeserializer(this.evaluator, type) && !(type instanceof WrapperTypeInfo);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid() || type.getBasicType() == BasicType.SOBJECT;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return CollectionTypeInfoUtil.isMapOrCollection(type) && type.acceptArguments(this);
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }
    }

    private static class ReturnTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final AccessEvaluator evaluator;

        private ReturnTypeVisitor(AccessEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return !(AnnotationRuleUtil.isConnectApiAndNotBatchResult(type) && AnnotationRuleUtil.hasConnectSerializer(type) || !this.evaluator.hasRemoteAction(type) && type instanceof WrapperTypeInfo);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid() || type.getBasicType() == BasicType.SOBJECT;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return CollectionTypeInfoUtil.isMapOrCollection(type) && type.acceptArguments(this);
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }
    }
}

