/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HttpRequestContextRule
implements AnnotationContextRule {
    private final ModifierOrAnnotationTypeInfo modifier;

    public HttpRequestContextRule(ModifierOrAnnotationTypeInfo modifier) {
        assert (modifier == AnnotationTypeInfos.HTTP_DELETE || modifier == AnnotationTypeInfos.HTTP_GET || modifier == AnnotationTypeInfos.HTTP_PATCH || modifier == AnnotationTypeInfos.HTTP_POST || modifier == AnnotationTypeInfos.HTTP_PUT);
        this.modifier = modifier;
    }

    @Override
    public void validate(MethodContext context) {
        TypeInfoVisitor.Default returnVisitor;
        TypeInfoVisitor.Default parameterVisitor;
        MethodInfo method = context.getMethodInfo();
        HashMap<TypeInfo, Boolean> isHttpAllowed = new HashMap<TypeInfo, Boolean>();
        if (Version.V174.isLessThanOrEqual(context.getVersion())) {
            TypeInfo restRequest = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_REST_REQUEST);
            TypeInfo restResponse = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_REST_RESPONSE);
            isHttpAllowed.put(restRequest, true);
            isHttpAllowed.put(restResponse, true);
        }
        if (method.getModifiers().some(AnnotationTypeInfos.HTTP_GET, AnnotationTypeInfos.HTTP_DELETE) && !method.getParameters().isEmpty()) {
            if (Version.V174.isLessThanOrEqual(context.getVersion())) {
                context.addNodeError(I18nSupport.getLabel("invalid.method.with.parameters", this.modifier));
                return;
            }
            parameterVisitor = new GetAndDeleteContextRuleVisitor(isHttpAllowed.keySet());
            returnVisitor = parameterVisitor;
        } else {
            parameterVisitor = new ContextRuleVisitor(context.getSymbols().getAccessEvaluator(), isHttpAllowed, Mode.PARAMETER);
            returnVisitor = new ContextRuleVisitor(context.getSymbols().getAccessEvaluator(), isHttpAllowed, Mode.RETURN_TYPE);
        }
        AnnotationRuleUtil.validate(context, this.modifier, parameterVisitor, returnVisitor);
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }

    private static class ContextRuleVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final AccessEvaluator evaluator;
        private final Map<TypeInfo, Boolean> isHttpAllowed;
        private final Mode mode;
        private final Set<TypeInfo> visited;

        public ContextRuleVisitor(AccessEvaluator evaluator, Map<TypeInfo, Boolean> isHttpAllowed, Mode mode) {
            this.evaluator = evaluator;
            this.isHttpAllowed = isHttpAllowed;
            this.mode = mode;
            this.visited = new HashSet<TypeInfo>();
        }

        private Boolean visitStandard(TypeInfo type) {
            Boolean hasValue = this.isHttpAllowed.get(type);
            if (hasValue != null) {
                return hasValue;
            }
            if (this.visited.contains(type)) {
                return true;
            }
            this.visited.add(type);
            if (AnnotationRuleUtil.isConnectApiAndNotBatchResult(type)) {
                boolean hasAnnotation;
                switch (this.mode) {
                    case PARAMETER: {
                        hasAnnotation = AnnotationRuleUtil.hasConnectDeserializer(this.evaluator, type);
                        break;
                    }
                    case RETURN_TYPE: {
                        hasAnnotation = AnnotationRuleUtil.hasConnectSerializer(type);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                return hasAnnotation;
            }
            if (this.evaluator.isReservedNamespace(type.getNamespace())) {
                this.isHttpAllowed.put(type, false);
                return false;
            }
            for (FieldInfo field : type.fields().all()) {
                if (!field.getModifiers().none(ModifierTypeInfos.STATIC, ModifierTypeInfos.TRANSIENT) || field.getType().accept(this).booleanValue()) continue;
                this.isHttpAllowed.put(type, false);
                return false;
            }
            this.isHttpAllowed.put(type, true);
            return true;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return this.visitStandard(type);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid() || type.getBasicType() == BasicType.SOBJECT;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            if (CollectionTypeInfoUtil.isList(type)) {
                return CollectionTypeInfoUtil.getElementType(type).accept(this);
            }
            if (CollectionTypeInfoUtil.isMap(type)) {
                return CollectionTypeInfoUtil.getKeyType(type).getBasicType() == BasicType.STRING && CollectionTypeInfoUtil.getValueType(type).accept(this) != false;
            }
            return !CollectionTypeInfoUtil.isSet(type) && this.visitStandard(type.getRootUnreifiedType()) != false && MoreIterables.ensureNone(type.getTypeArguments(), argumentType -> argumentType.accept(this) == false);
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }
    }

    private static class GetAndDeleteContextRuleVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final Set<TypeInfo> allowedTypes;

        private GetAndDeleteContextRuleVisitor(Set<TypeInfo> allowedTypes) {
            this.allowedTypes = allowedTypes;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return this.allowedTypes.contains(type);
        }
    }

    private static enum Mode {
        PARAMETER,
        RETURN_TYPE;

    }
}

