/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class GlobalContextRule
implements AnnotationContextRule {
    private static final AnnotationContextRule INSTANCE = new GlobalContextRule();
    private static final TypeInfoVisitor<Boolean> VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return type.getModifiers().has(ModifierTypeInfos.GLOBAL);
        }
    };

    private GlobalContextRule() {
    }

    public static AnnotationContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        MethodInfo method = context.getMethodInfo();
        if (method.getModifiers().not(AnnotationTypeInfos.DEPRECATED)) {
            if (method.getReturnType().getModifiers().has(AnnotationTypeInfos.DEPRECATED)) {
                context.addNodeError(I18nSupport.getLabel("global.deprecate.if.return.deprecated", method.getReturnType()));
            }
            for (TypeInfo parameterType : method.getParameterTypes()) {
                if (!parameterType.getModifiers().has(AnnotationTypeInfos.DEPRECATED)) continue;
                context.addNodeError(I18nSupport.getLabel("global.deprecate.if.parameter.deprecated", parameterType));
            }
        }
        AnnotationRuleUtil.validate(context, ModifierTypeInfos.GLOBAL, VISITOR, VISITOR);
    }

    @Override
    public void validate(FieldContext context) {
        FieldInfo field = context.getFieldInfo();
        if (field.getType().getModifiers().has(AnnotationTypeInfos.DEPRECATED)) {
            context.addNodeError(I18nSupport.getLabel("global.deprecate.if.type.deprecated", field.getType()));
        }
    }

    @Override
    public void validate(TypeContext context) {
    }
}

