/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRules;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class AnnotationRuleGroup {
    public static final AnnotationRuleGroup EMPTY = AnnotationRuleGroup.builder().build();
    private final ModifierOrAnnotationTypeInfo modifier;
    private final Set<AnnotationRule> softRules;
    private final Set<AnnotationRule> hardRules;
    private final AnnotationContextRule contextRule;

    private AnnotationRuleGroup(Builder builder) {
        this.modifier = builder.modifier;
        this.softRules = builder.softRules;
        this.hardRules = builder.hardRules;
        this.contextRule = builder.contextRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(AnnotationContext context) {
        if (context.getModifiers().getDuplicates().contains(this.modifier)) {
            context.addError(I18nSupport.getLabel("duplicate.modifier", this.modifier));
        }
        for (AnnotationRule rule : this.hardRules) {
            rule.validate(context, context.getModifiers(), this.modifier.toString());
            if (!context.getErrors().isInvalid(context.getNode())) continue;
            return;
        }
        for (AnnotationRule rule : this.softRules) {
            rule.validate(context, context.getModifiers(), this.modifier.toString());
        }
        if (this.contextRule != null) {
            context.accept(this.contextRule);
        }
    }

    public static class Builder {
        private Set<AnnotationRule> softRules = Collections.emptySet();
        private Set<AnnotationRule> hardRules = Collections.emptySet();
        private AnnotationContextRule contextRule;
        private ModifierOrAnnotationTypeInfo modifier;

        private Builder() {
        }

        public AnnotationRuleGroup build() {
            assert (this.modifier == null || this.hardRules.stream().filter(input -> input instanceof AnnotationRules.AllowedElementsRule).findFirst().isPresent()) : "illegal modifier/annotation without element specific rule";
            return new AnnotationRuleGroup(this);
        }

        public Builder setContextRule(AnnotationContextRule contextRule) {
            this.contextRule = contextRule;
            return this;
        }

        public Builder addSoftRules(AnnotationRule ... softRules) {
            this.softRules = ImmutableSet.copyOf(Sets.newLinkedHashSet(Arrays.asList(softRules)));
            return this;
        }

        public Builder addHardRules(AnnotationRule ... rules) {
            this.hardRules = ImmutableSet.copyOf(Sets.newLinkedHashSet(Arrays.asList(rules)));
            return this;
        }

        public Builder setModifier(ModifierOrAnnotationTypeInfo modifier) {
            this.modifier = modifier;
            return this;
        }
    }
}

