/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.property.rule;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class AnnotationPropertyRuleGroup {
    public static final AnnotationPropertyRuleGroup NONE = AnnotationPropertyRuleGroup.builder().build();
    private final Set<AnnotationPropertyRule> softRules;
    private final Set<AnnotationPropertyRule> hardRules;

    private AnnotationPropertyRuleGroup(Builder builder) {
        this.hardRules = builder.hardRules;
        this.softRules = builder.softRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(AnnotationContext context, AnnotationParameter parameter) {
        for (AnnotationPropertyRule hardRule : this.hardRules) {
            hardRule.validate(context, parameter);
            if (!context.getErrors().isInvalid((AstNode)parameter)) continue;
            return;
        }
        for (AnnotationPropertyRule rule : this.softRules) {
            rule.validate(context, parameter);
        }
    }

    public Iterable<AnnotationPropertyRule> getRules() {
        return Iterables.concat(this.hardRules, this.softRules);
    }

    public static class Builder {
        private Set<AnnotationPropertyRule> softRules = Collections.emptySet();
        private Set<AnnotationPropertyRule> hardRules = Collections.emptySet();

        private Builder() {
        }

        public Builder addHardRules(AnnotationPropertyRule ... hardRules) {
            this.hardRules = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(hardRules)));
            return this;
        }

        public Builder addSoftRules(AnnotationPropertyRule ... softRules) {
            this.softRules = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(softRules)));
            return this;
        }

        public AnnotationPropertyRuleGroup build() {
            return new AnnotationPropertyRuleGroup(this);
        }
    }
}

