/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.modifier.SharingTypeCalculator;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SharingTypeCalculatorTest {
    private static final ModifierGroup WITH_SHARING = ModifierGroup.builder().addModifiers(ModifierTypeInfos.WITH_SHARING).build();
    private static final ModifierGroup WITHOUT_SHARING = ModifierGroup.builder().addModifiers(ModifierTypeInfos.WITHOUT_SHARING).build();
    @Mock
    private ParentTable parents;
    @Mock
    private ParentTable superParents;
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo superType;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.type.parents()).thenReturn((Object)this.parents);
        Mockito.when((Object)this.superType.parents()).thenReturn((Object)this.superParents);
        Mockito.when((Object)this.parents.isResolved()).thenReturn((Object)true);
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superType);
        Mockito.when((Object)this.superParents.isResolved()).thenReturn((Object)true);
        Mockito.when((Object)this.superParents.superType()).thenReturn(null);
    }

    @Test
    public void testWith() {
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)WITH_SHARING);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.WITH)));
    }

    @Test
    public void testWithout() {
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)WITHOUT_SHARING);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.WITHOUT)));
    }

    @Test
    public void testInherit() {
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        Mockito.when((Object)this.superType.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.INHERIT)));
        Mockito.when((Object)this.superType.getModifiers()).thenReturn((Object)WITH_SHARING);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.WITH)));
        Mockito.when((Object)this.superType.getModifiers()).thenReturn((Object)WITHOUT_SHARING);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.WITHOUT)));
    }

    @Test
    public void testApexBaseObject() {
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)InternalTypeInfos.APEX_OBJECT);
        MatcherAssert.assertThat((Object)((Object)SharingTypeCalculator.get().resolve(this.type)), (Matcher)Matchers.is((Object)((Object)SharingType.INHERIT)));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testParentsNotResolved() {
        Mockito.when((Object)this.parents.isResolved()).thenReturn((Object)false);
        SharingTypeCalculator.get().resolve(this.type);
    }
}

