/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.ast.Modifier;
import java.util.List;

public class OldModifiers {
    private long modifiers = 0L;

    private OldModifiers() {
    }

    public static OldModifiers fromModifiers(List<Modifier> modifiers) {
        final OldModifiers oldModifiers = new OldModifiers();
        for (Modifier modifier : modifiers) {
            modifier._switch(new Modifier.SwitchBlock(){

                @Override
                public void _case(Modifier.TestMethodModifier x) {
                    oldModifiers.set(ModifierType.TestMethod);
                }

                @Override
                public void _case(Modifier.GlobalModifier x) {
                    oldModifiers.set(ModifierType.GlobalIdentifier);
                }

                @Override
                public void _case(Modifier.WebServiceModifier x) {
                    oldModifiers.set(ModifierType.WebService);
                }

                @Override
                public void _case(Modifier.PublicModifier x) {
                    oldModifiers.set(ModifierType.PublicIdentifier);
                }

                @Override
                public void _case(Modifier.PrivateModifier x) {
                    oldModifiers.set(ModifierType.PrivateIdentifier);
                }

                @Override
                public void _case(Modifier.ProtectedModifier x) {
                    oldModifiers.set(ModifierType.ProtectedIdentifier);
                }

                @Override
                public void _case(Modifier.WithSharingModifier x) {
                    oldModifiers.set(ModifierType.WithSharing);
                }

                @Override
                public void _case(Modifier.WithoutSharingModifier x) {
                    oldModifiers.set(ModifierType.WithoutSharing);
                }

                @Override
                public void _case(Modifier.StaticModifier x) {
                    oldModifiers.set(ModifierType.StaticIdentifier);
                }

                @Override
                public void _case(Modifier.TransientModifier x) {
                    oldModifiers.set(ModifierType.TransientIdentifier);
                }

                @Override
                public void _case(Modifier.AbstractModifier x) {
                    oldModifiers.set(ModifierType.AbstractIdentifier);
                }

                @Override
                public void _case(Modifier.FinalModifier x) {
                    oldModifiers.set(ModifierType.FinalIdentifier);
                }

                @Override
                public void _case(Modifier.OverrideModifier x) {
                    oldModifiers.set(ModifierType.MethodOverrides);
                }

                @Override
                public void _case(Modifier.VirtualModifier x) {
                    oldModifiers.set(ModifierType.VirtualIdentifier);
                }

                @Override
                public void _case(Modifier.Annotation x) {
                }
            });
        }
        return oldModifiers;
    }

    public void set(ModifierType bit) {
        this.modifiers |= 1L << bit.ordinal();
    }

    public void unset(ModifierType bit) {
        this.modifiers &= 1L << bit.ordinal() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean get(ModifierType bit) {
        return (this.modifiers & 1L << bit.ordinal()) != 0L;
    }

    public long getModifiers() {
        return this.modifiers;
    }

    public static enum ModifierType {
        TestMethod,
        PublicIdentifier,
        WebService,
        AuraEnabled(true),
        ReadOnly(true),
        FinalIdentifier,
        PrivateIdentifier,
        ProtectedIdentifier,
        AbstractIdentifier,
        MethodOverrides,
        StaticIdentifier,
        VirtualIdentifier,
        GlobalIdentifier,
        WithSharing,
        WithoutSharing,
        TransientIdentifier,
        Future(true),
        PublicGetter,
        PrivateGetter,
        GlobalGetter,
        LegacyDefaultVisibilityGetter,
        PublicSetter,
        PrivateSetter,
        GlobalSetter,
        LegacyDefaultVisibilitySetter,
        CallOut,
        ProtectedGetter,
        ProtectedSetter,
        Deprecated(true),
        Constructable,
        SfdcOnly(true),
        PrivateApi(true),
        AllowCertifiedApex(true),
        HiddenFromDoc(true),
        RemoteAction(true),
        RestResource(true),
        HttpGet(true),
        HttpPost(true),
        HttpPut(true),
        HttpPatch(true),
        HttpDelete(true),
        SeeAllData,
        OnInstall,
        DisplayLabel,
        ScheduleAccess,
        Schedulable,
        Batchable,
        MessageSetName,
        VisibleApiVersion(true),
        MinApiVersion,
        MaxApiVersion,
        UseConnectSerializer(true),
        UseConnectDeserializer(true),
        TestVisible(true);

        public final boolean isAnnotation;

        private ModifierType() {
            this(false);
        }

        private ModifierType(boolean annotation) {
            this.isAnnotation = annotation;
        }
    }
}

