/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ModifierInfoBuilder
extends ModifierGroupBuilder {
    private final List<ModifierTypeInfo> modifiers;
    private final List<Modifier.Annotation> jadtAnnotations;
    private Loc loc = Loc._SyntheticLoc();

    ModifierInfoBuilder() {
        this.modifiers = Lists.newArrayList();
        this.jadtAnnotations = Lists.newArrayList();
    }

    @Override
    public ModifierGroupBuilder addModifiers(ModifierTypeInfo ... modifiers) {
        return this.addModifierTypes(Arrays.asList(modifiers));
    }

    @Override
    public ModifierGroupBuilder addModifierTypes(List<ModifierTypeInfo> modifiers) {
        this.modifiers.addAll(modifiers);
        return this;
    }

    @Override
    public ModifierGroupBuilder addIntersectionOfModifiers(ModifierGroup originalModifiers, ModifierTypeInfo ... modifiers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierTypeInfo modifier : modifiers) {
            if (!originalModifiers.has(modifier)) continue;
            builder.add(modifier);
        }
        return this.addModifierTypes((List<ModifierTypeInfo>)((Object)builder.build()));
    }

    private ModifierGroupBuilder removeModifiers(List<ModifierTypeInfo> modifiers) {
        Iterator<ModifierTypeInfo> iterator = this.modifiers.iterator();
        block0: while (iterator.hasNext()) {
            ModifierTypeInfo oldModifier = iterator.next();
            for (ModifierTypeInfo removeModifier : modifiers) {
                if (!removeModifier.equals(oldModifier)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return this;
    }

    @Override
    public ModifierGroupBuilder removeModifiers(ModifierTypeInfo ... modifiers) {
        return this.removeModifiers(Arrays.asList(modifiers));
    }

    @Override
    public ModifierGroupBuilder removeAllVisibilityModifiers() {
        return this.removeModifiers(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.PROTECTED, ModifierTypeInfos.PRIVATE);
    }

    @Override
    public ModifierGroup build() {
        return new ModifierGroup(this);
    }

    public List<ModifierTypeInfo> getMyModifiers() {
        return this.modifiers;
    }

    public List<Modifier.Annotation> getMyAnnotations() {
        return this.jadtAnnotations;
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    @Override
    public ModifierGroupBuilder setLoc(Loc loc) {
        this.loc = loc;
        return this;
    }

    @Override
    public ModifierGroupBuilder addAstModifiers(List<Modifier> modifiers) {
        for (Modifier modifier : AstNodeFactory.filterNotNull(modifiers)) {
            this.modifiers.addAll((Collection<ModifierTypeInfo>)modifier.match(ModifierToType.INSTANCE));
            this.jadtAnnotations.addAll((Collection<Modifier.Annotation>)modifier.match(ModifierToAnnotation.INSTANCE));
        }
        return this;
    }

    @Override
    public ModifierGroupBuilder addAstModifiers(Modifier ... modifiers) {
        this.addAstModifiers(Arrays.asList(modifiers));
        return this;
    }

    private static class ModifierToAnnotation
    extends Modifier.MatchBlockWithDefault<List<Modifier.Annotation>> {
        private static final ModifierToAnnotation INSTANCE = new ModifierToAnnotation();

        private ModifierToAnnotation() {
        }

        @Override
        public List<Modifier.Annotation> _case(Modifier.Annotation x) {
            return ImmutableList.of(x);
        }

        @Override
        protected List<Modifier.Annotation> _default(Modifier x) {
            return ImmutableList.of();
        }
    }

    private static class ModifierToType
    implements Modifier.MatchBlock<List<ModifierTypeInfo>> {
        private static final ModifierToType INSTANCE = new ModifierToType();

        private ModifierToType() {
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.TestMethodModifier x) {
            return ImmutableList.of(ModifierTypeInfos.TEST_METHOD);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.GlobalModifier x) {
            return ImmutableList.of(ModifierTypeInfos.GLOBAL);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.WebServiceModifier x) {
            return ImmutableList.of(ModifierTypeInfos.WEB_SERVICE, ModifierTypeInfos.GLOBAL);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.PublicModifier x) {
            return ImmutableList.of(ModifierTypeInfos.PUBLIC);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.PrivateModifier x) {
            return ImmutableList.of(ModifierTypeInfos.PRIVATE);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.ProtectedModifier x) {
            return ImmutableList.of(ModifierTypeInfos.PROTECTED);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.WithSharingModifier x) {
            return ImmutableList.of(ModifierTypeInfos.WITH_SHARING);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.WithoutSharingModifier x) {
            return ImmutableList.of(ModifierTypeInfos.WITHOUT_SHARING);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.StaticModifier x) {
            return ImmutableList.of(ModifierTypeInfos.STATIC);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.TransientModifier x) {
            return ImmutableList.of(ModifierTypeInfos.TRANSIENT);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.AbstractModifier x) {
            return ImmutableList.of(ModifierTypeInfos.ABSTRACT);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.FinalModifier x) {
            return ImmutableList.of(ModifierTypeInfos.FINAL);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.OverrideModifier x) {
            return ImmutableList.of(ModifierTypeInfos.OVERRIDE);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.VirtualModifier x) {
            return ImmutableList.of(ModifierTypeInfos.VIRTUAL);
        }

        @Override
        public List<ModifierTypeInfo> _case(Modifier.Annotation x) {
            return ImmutableList.of();
        }
    }
}

