/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.JadtTester;
import apex.jorje.data.Loc;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.iterable.MoreLists;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.tester.matchers.HasAnnotationParameter;
import com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ModifierGroupTest {
    @Test
    public void testValidModifiers() {
        ImmutableList<Modifier> modifiers = ImmutableList.of(Modifier._PublicModifier(Loc._SyntheticLoc()), Modifier._AbstractModifier(Loc._SyntheticLoc()));
        ModifierGroup theModifiers = ModifierGroup.builder().addAstModifiers(modifiers).build();
        MatcherAssert.assertThat((Object)theModifiers.getJavaModifiers(), (Matcher)Matchers.is((Object)1025));
        MatcherAssert.assertThat(theModifiers.all(), (Matcher)IsCollectionContaining.hasItems((Object[])new ModifierOrAnnotationTypeInfo[]{ModifierTypeInfos.PUBLIC, ModifierTypeInfos.ABSTRACT}));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.STATIC), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.FINAL), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.ABSTRACT), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.PUBLIC), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWebServiceAddsGlobal() {
        ImmutableList<Modifier> modifiers = ImmutableList.of(Modifier._WebServiceModifier(Loc._SyntheticLoc()));
        ModifierGroup theModifiers = ModifierGroup.builder().addAstModifiers(modifiers).build();
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.GLOBAL), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.WEB_SERVICE), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testStaticAndFinalModifier() {
        ImmutableList<Modifier> modifiers = ImmutableList.of(Modifier._StaticModifier(Loc._SyntheticLoc()), Modifier._FinalModifier(Loc._SyntheticLoc()));
        ModifierGroup theModifiers = ModifierGroup.builder().addAstModifiers(modifiers).build();
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.STATIC), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)theModifiers.has(ModifierTypeInfos.FINAL), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testClone() {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.FINAL).build();
        ModifierGroup clone = modifiers.copy().setLoc(JadtTester.loc((int)0, (int)0)).build();
        MatcherAssert.assertThat(modifiers.all(), (Matcher)Matchers.is(clone.all()));
        MatcherAssert.assertThat((Object)modifiers.getJavaModifiers(), (Matcher)Matchers.is((Object)clone.getJavaModifiers()));
        MatcherAssert.assertThat((Object)modifiers.getLoc(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)clone.getLoc())));
    }

    @Test
    public void testAddModifiers() {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.FINAL).build();
        MatcherAssert.assertThat(modifiers.all(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(modifiers.all(), (Matcher)Matchers.hasItem((Object)ModifierTypeInfos.FINAL));
    }

    @Test
    public void testRemoveModifiers() {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).removeModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build();
        MatcherAssert.assertThat(modifiers.all(), (Matcher)Matchers.empty());
    }

    @Test
    public void testAddAnnotation() {
        ModifierGroup modifiers = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("SfdcOnly"), JadtFactory.annotationKeyValues("IsTest", "SeeAllData", "true"), JadtFactory.annotationKeyValues("TestSetup", "OnInstall", "false"), JadtFactory.annotationKeyValues("RestResource", "UrlMapping", "foobar")).build().resolve();
        MatcherAssert.assertThat((Object)modifiers.has(AnnotationTypeInfos.SFDC_ONLY), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)modifiers.get(AnnotationTypeInfos.SFDC_ONLY), HasAnnotationParameter.annotationTrue("value"));
        MatcherAssert.assertThat((Object)modifiers.has(AnnotationTypeInfos.IS_TEST), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)modifiers.get(AnnotationTypeInfos.IS_TEST), HasAnnotationParameter.annotationTrue("seeAllData"));
        MatcherAssert.assertThat((Object)modifiers.has(AnnotationTypeInfos.TEST_SETUP), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)modifiers.get(AnnotationTypeInfos.TEST_SETUP), HasAnnotationParameter.annotationFalse("onInstall"));
        MatcherAssert.assertThat((Object)modifiers.has(AnnotationTypeInfos.REST_RESOURCE), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)modifiers.get(AnnotationTypeInfos.REST_RESOURCE), HasAnnotationParameter.annotationValue("urlMapping", "foobar"));
        MatcherAssert.assertThat((Object)modifiers.has(AnnotationTypeInfos.AURA_ENABLED), (Matcher)Matchers.is((Object)false));
    }

    @DataProvider
    Object[][] allModifierOrAnnotationTypes() {
        return MoreLists.to2dArray(ModifierOrAnnotationTypeInfo.class, TypeInfoTables.ANNOTATION_TYPES.values(), TypeInfoTables.MODIFIER_TYPES.values());
    }

    @Test(dataProvider="allModifierOrAnnotationTypes")
    public void testAllAnnotationsHaveRules(ModifierOrAnnotationTypeInfo modifier) {
        MatcherAssert.assertThat((String)(modifier + " has no defined rules"), (Object)modifier.getRuleGroup(), (Matcher)Matchers.notNullValue());
    }
}

