/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class Modifier
extends ModifierOrAnnotation {
    private final Loc loc;
    private final ModifierTypeInfo type;

    public Modifier(Loc loc, ModifierTypeInfo type) {
        this.loc = loc;
        this.type = type;
        this.setType(type);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.type.isBytecodeVisible()) {
            emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit(this.getType().getBytecodeName(), true);
            if (this.type == ModifierTypeInfos.TEST_METHOD) {
                emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit("testMethod@onInstall", false);
                emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit("testMethod@seeAllData", false);
            }
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public ModifierTypeInfo getModifierType() {
        return this.type;
    }

    @Override
    public AnnotationParameter getParameter(String name) {
        return null;
    }

    @Override
    public TypeInfo getDefiningType() {
        throw new UnsupportedOperationException();
    }
}

