/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.member.bridge.InterfaceErasedBridge;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class InterfaceErasedBridgeTest {
    private static final MethodInfo INTERFACE = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo METHOD = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo RETURNS_INTEGER = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo RETURNS_OBJECT = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.OBJECT).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo RETURNS_ARGUMENT_TYPE = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(ArgumentTypeInfos.T).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo RETURNS_NESTED_ARGUMENT_TYPE = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.LIST).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();

    @Test
    public void testNoInterface() {
        METHOD.setMethodInterface(null);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNoGenericInterface() {
        METHOD.setMethodInterface(INTERFACE);
        INTERFACE.setMethodInterface(null);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testObjectReturnType() {
        METHOD.setMethodInterface(INTERFACE);
        INTERFACE.setMethodInterface(RETURNS_OBJECT);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNonArgumentTypeReturnType() {
        METHOD.setMethodInterface(INTERFACE);
        INTERFACE.setMethodInterface(RETURNS_INTEGER);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testArgumentTypeReturnType() {
        METHOD.setMethodInterface(INTERFACE);
        INTERFACE.setMethodInterface(RETURNS_ARGUMENT_TYPE);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testUnreifiedReturnType() {
        METHOD.setMethodInterface(INTERFACE);
        INTERFACE.setMethodInterface(RETURNS_NESTED_ARGUMENT_TYPE);
        MatcherAssert.assertThat((Object)InterfaceErasedBridge.get().required(METHOD), (Matcher)Matchers.is((Object)true));
    }
}

