/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import java.util.List;

public class InterfaceErasedBridge
implements Bridge {
    private static final InterfaceErasedBridge INSTANCE = new InterfaceErasedBridge();

    private InterfaceErasedBridge() {
    }

    public static InterfaceErasedBridge get() {
        return INSTANCE;
    }

    @Override
    public boolean required(MethodInfo methodImpl) {
        MethodInfo parameterizedMethodInterface = methodImpl.getMethodInterface();
        if (parameterizedMethodInterface == null) {
            return false;
        }
        MethodInfo unparameterizedMethodInterface = parameterizedMethodInterface.getMethodInterface();
        return unparameterizedMethodInterface != null && !GenericTypeInfoUtil.isReifiedType(unparameterizedMethodInterface.getReturnType()) && !methodImpl.getReturnType().equals(TypeInfos.OBJECT);
    }

    @Override
    public Method create(BridgeMethodCreator definingNode, final MethodInfo methodInfo) {
        MethodInfo parameterizedMethodInterface = methodInfo.getMethodInterface();
        MethodInfo unparameterizedMethodInterface = parameterizedMethodInterface.getMethodInterface();
        final List<Parameter> reifiedParameters = ArgumentTypeInfoConverter.convertParameters(unparameterizedMethodInterface.getParameters());
        ModifierGroup modifiers = methodInfo.getModifiers().copy().removeModifiers(ModifierTypeInfos.STATIC, ModifierTypeInfos.ABSTRACT).addModifiers(ModifierTypeInfos.BRIDGE).build();
        SimpleStatement root = new SimpleStatement(definingNode, SimpleStatement.Returnable.YES){

            @Override
            public void emit(Emitter emitter) {
                if (!methodInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                }
                for (int i = 0; i < methodInfo.getParameterTypes().size(); ++i) {
                    emitter.emitVar(Loc._SyntheticLoc(), 25, i + 1);
                    TypeConversion.emit(Loc._SyntheticLoc(), emitter, ((Parameter)reifiedParameters.get(i)).getType(), methodInfo.getParameterTypes().get(i));
                }
                int opcode = methodInfo.getModifiers().has(ModifierTypeInfos.STATIC) ? 184 : 183;
                AsmMethod bridge = AsmMethod.builder().setOpcode(opcode).setDefiningTypeAsBytecodeMethodName(methodInfo.getDefiningType()).setFunction(methodInfo.getMangledCanonicalName()).setSignature(methodInfo.getSignature()).build();
                emitter.emit(Loc._SyntheticLoc(), bridge);
                emitter.emit(Loc._SyntheticLoc(), methodInfo.hasReturnValue() ? 176 : 177);
            }
        };
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(methodInfo.getDefiningType()).setReturnType(TypeInfos.OBJECT).setName(unparameterizedMethodInterface.getMangledName()).setModifiers(modifiers).setGenerated(Generated.BRIDGE).copyParameters(reifiedParameters), root);
    }
}

