/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.member.bridge.InterfaceBridge;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestTypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InterfaceBridgeTest {
    private static final ModifierGroup ONLY_STATIC = ModifierGroup.builder().addModifiers(ModifierTypeInfos.STATIC).build();
    private static final MethodInfo WRONG_TYPE = StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.DOUBLE).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.INTEGER).build();
    private static final MethodInfo WRONG_NAME = StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName("FOO_ID").setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.INTEGER).build();
    private static final MethodInfo WRONG_SIGNATURE = StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.LONG).build();
    private static final MethodInfo STATIC = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ONLY_STATIC).setNamedParameterTypes(TypeInfos.INTEGER).build();
    private static final TypeInfo UNTRUSTED_FOO_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyInterface((String)"IFoo"))).buildResolved();
    private static final TypeInfo TRUSTED_FOO_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.TRUSTED_SOURCE, CompilationUnitBuilder.emptyInterface((String)"IFoo"))).buildResolved();
    private static final TypeInfo FILE_BASE_FOO_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.FILE_BASE_SOURCE, CompilationUnitBuilder.emptyInterface((String)"IFoo"))).buildResolved();

    private static MethodInfo createInterfaceMethod() {
        return InterfaceBridgeTest.createInterfaceMethod(TestTypeInfos.create(CompilationUnitBuilder.emptyInterface((String)"IBar")));
    }

    private static MethodInfo createInterfaceMethod(TypeInfo interfaceType) {
        return StandardMethodInfo.builder().setDefiningType(interfaceType).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.INTEGER).build();
    }

    private static MethodInfo createMethod() {
        return StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.INTEGER).build();
    }

    @DataProvider
    Object[][] implementsData() {
        return new Object[][]{{InterfaceBridgeTest.createMethod(), InterfaceBridgeTest.createInterfaceMethod(), false}, {WRONG_TYPE, InterfaceBridgeTest.createInterfaceMethod(), true}, {WRONG_NAME, InterfaceBridgeTest.createInterfaceMethod(), true}, {WRONG_SIGNATURE, InterfaceBridgeTest.createInterfaceMethod(), true}, {STATIC, InterfaceBridgeTest.createInterfaceMethod(), true}, {InterfaceBridgeTest.createMethod(), null, false}, {InterfaceBridgeTest.createMethod(), InterfaceBridgeTest.createInterfaceMethod(UNTRUSTED_FOO_T), true}, {InterfaceBridgeTest.createMethod(), InterfaceBridgeTest.createInterfaceMethod(TRUSTED_FOO_T), true}, {InterfaceBridgeTest.createMethod(), InterfaceBridgeTest.createInterfaceMethod(FILE_BASE_FOO_T), false}};
    }

    @Test(dataProvider="implementsData")
    public void testImplements(MethodInfo method, MethodInfo interfaceMethod, boolean expected) {
        method.setMethodInterface(interfaceMethod);
        MatcherAssert.assertThat((Object)InterfaceBridge.get().required(method), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] reifiedData() {
        return new Object[][]{{InterfaceBridgeTest.createMethod(), StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(ArgumentTypeInfos.T).build(), true}, {InterfaceBridgeTest.createMethod(), StandardMethodInfo.builder().setDefiningType(TestConstants.BAR).setName(JadtTester.FOO_ID).setReturnType(ArgumentTypeInfos.T).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(TypeInfos.INTEGER).build(), false}};
    }

    @Test(dataProvider="reifiedData")
    public void testReified(MethodInfo reifiedMethod, MethodInfo unreifiedMethod, boolean expected) {
        MethodInfo interfaceMethod = InterfaceBridgeTest.createInterfaceMethod();
        reifiedMethod.setMethodInterface(interfaceMethod);
        interfaceMethod.setMethodInterface(unreifiedMethod);
        MatcherAssert.assertThat((Object)InterfaceBridge.get().required(reifiedMethod), (Matcher)Is.is((Object)expected));
    }
}

