/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.base.MoreObjects;
import java.util.List;

public class InterfaceBridge
implements Bridge {
    private static final InterfaceBridge INSTANCE = new InterfaceBridge();

    private InterfaceBridge() {
    }

    public static InterfaceBridge get() {
        return INSTANCE;
    }

    @Override
    public boolean required(MethodInfo methodImpl) {
        MethodInfo methodInterface = methodImpl.getMethodInterface();
        if (methodInterface == null) {
            return false;
        }
        MethodInfo rawMethodInterface = MoreObjects.firstNonNull(methodInterface.getMethodInterface(), methodInterface);
        return methodInterface != null && (GenericTypeInfoUtil.isUserGenericInterface(rawMethodInterface.getDefiningType()) || !TypeInfoEquivalence.isEquivalent(methodImpl.getReturnType(), methodInterface.getReturnType()) || !this.isEquivalentTypedSignature(methodImpl.getSignature(), rawMethodInterface.getSignature()) || methodImpl.getModifiers().has(ModifierTypeInfos.STATIC) || !methodImpl.getName().equals(rawMethodInterface.getName()));
    }

    @Override
    public Method create(BridgeMethodCreator definingNode, final MethodInfo methodInfo) {
        MethodInfo methodInterface = methodInfo.getMethodInterface();
        boolean isUserGenericInterface = GenericTypeInfoUtil.isUserGenericInterface(methodInterface.getDefiningType());
        String name = isUserGenericInterface ? MethodNameMangler.getGenericInterfaceMangled(methodInterface.getDefiningType(), methodInterface.getName()) : methodInterface.getMangledName();
        final TypeInfo returnType = this.createReturnType(isUserGenericInterface, methodInfo);
        final List<Parameter> parameters = methodInterface.getMethodInterface() != null ? ArgumentTypeInfoConverter.convertParameters(methodInterface.getMethodInterface().getParameters()) : methodInterface.getParameters();
        ModifierGroup modifiers = methodInfo.getModifiers().copy().removeModifiers(ModifierTypeInfos.STATIC, ModifierTypeInfos.ABSTRACT).addModifiers(ModifierTypeInfos.BRIDGE).build();
        SimpleStatement root = new SimpleStatement(definingNode, SimpleStatement.Returnable.YES){

            @Override
            public void emit(Emitter emitter) {
                if (!methodInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                }
                for (int i = 0; i < methodInfo.getParameterTypes().size(); ++i) {
                    emitter.emitVar(Loc._SyntheticLoc(), 25, i + 1);
                    TypeConversion.emit(Loc._SyntheticLoc(), emitter, ((Parameter)parameters.get(i)).getType(), methodInfo.getParameterTypes().get(i));
                }
                int opcode = methodInfo.getModifiers().has(ModifierTypeInfos.STATIC) ? 184 : 183;
                AsmMethod bridge = AsmMethod.builder().setOpcode(opcode).setDefiningTypeAsBytecodeMethodName(methodInfo.getDefiningType()).setFunction(methodInfo.getMangledCanonicalName()).setSignature(methodInfo.getSignature()).build();
                emitter.emit(Loc._SyntheticLoc(), bridge);
                TypeConversion.emit(Loc._SyntheticLoc(), emitter, returnType, methodInfo.getReturnType());
                emitter.emit(Loc._SyntheticLoc(), methodInfo.hasReturnValue() ? 176 : 177);
            }
        };
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(methodInfo.getDefiningType()).setReturnType(returnType).setName(name).setModifiers(modifiers).setGenerated(Generated.BRIDGE).copyParameters(parameters), root);
    }

    private TypeInfo createReturnType(boolean isUserGenericInterface, MethodInfo methodInfo) {
        if (isUserGenericInterface && methodInfo.hasReturnValue()) {
            return TypeInfos.OBJECT;
        }
        MethodInfo methodInterface = methodInfo.getMethodInterface();
        switch (methodInterface.getReturnType().getBasicType()) {
            case LIST: 
            case SET: 
            case MAP: {
                return methodInterface.getReturnType();
            }
        }
        return GenericTypeInfoUtil.getRootType(methodInterface.getReturnType());
    }

    private boolean isEquivalentTypedSignature(Signature left, Signature right) {
        for (Pair<TypeInfo, TypeInfo> pair : EqualPairIterator.iterable(left.getParameterTypes(), right.getParameterTypes())) {
            if (TypeInfoEquivalence.isEquivalent((TypeInfo)pair.left, (TypeInfo)pair.right)) continue;
            return false;
        }
        return true;
    }
}

