/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.IntegerMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;

public class HashCodeBridge
implements Bridge {
    private static final HashCodeBridge INSTANCE = new HashCodeBridge();
    private static final ModifierGroup MODIFIERS = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.BRIDGE).build();

    private HashCodeBridge() {
    }

    public static HashCodeBridge get() {
        return INSTANCE;
    }

    @Override
    public boolean required(MethodInfo methodInfo) {
        return methodInfo.getName().equalsIgnoreCase("hashCode") && methodInfo.getReturnType().equals(TypeInfos.INTEGER) && methodInfo.getParameterTypes().isEmpty();
    }

    @Override
    public Method create(BridgeMethodCreator definingNode, final MethodInfo methodInfo) {
        SimpleStatement root = new SimpleStatement(definingNode){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.hashCodeBridge(methodInfo.getDefiningType(), methodInfo.getName()));
                emitter.emit(Loc._SyntheticLoc(), IntegerMethods.intValue());
                emitter.emit(Loc._SyntheticLoc(), 172);
            }
        };
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(methodInfo.getDefiningType()).setReturnType(InternalTypeInfos.PRIMITIVE_INTEGER).setName("hashCode").setModifiers(MODIFIERS).setGenerated(Generated.BRIDGE), root);
    }
}

