/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BridgeMethodCreatorTest {
    private static final SymbolResolver SYMBOLS = TestSymbolResolvers.createEmptySymbols();
    @Mock
    private MethodInfo methodInfo;
    @Mock
    private Bridge bridge;
    @Mock
    private Method method;
    @Mock
    private AstNode definingNode;
    private BridgeMethodCreator creator;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.method.getMethodInfo()).thenReturn((Object)this.methodInfo);
        this.creator = new BridgeMethodCreator(this.definingNode, Lists.newArrayList(this.method), ImmutableSet.of(this.bridge));
    }

    @Test
    public void testNonUserMethodNotBridged() {
        Mockito.when((Object)this.bridge.required(this.methodInfo)).thenReturn((Object)true);
        Mockito.when((Object)((Object)this.methodInfo.getGenerated())).thenReturn((Object)Generated.ANONYMOUS);
        this.creator.createMethods(SYMBOLS);
        MatcherAssert.assertThat(this.creator.getMethods(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testNotRequiredUserMethodBridged() {
        Mockito.when((Object)this.bridge.required(this.methodInfo)).thenReturn((Object)false);
        Mockito.when((Object)((Object)this.methodInfo.getGenerated())).thenReturn((Object)Generated.USER);
        this.creator.createMethods(SYMBOLS);
        MatcherAssert.assertThat(this.creator.getMethods(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testRequiredUserMethodBridged() {
        Mockito.when((Object)this.bridge.required(this.methodInfo)).thenReturn((Object)true);
        Mockito.when((Object)this.bridge.create(this.creator, this.methodInfo)).thenReturn((Object)this.method);
        Mockito.when((Object)((Object)this.methodInfo.getGenerated())).thenReturn((Object)Generated.USER);
        this.creator.createMethods(SYMBOLS);
        MatcherAssert.assertThat(this.creator.getMethods(), (Matcher)IsIterableContainingInOrder.contains((Object[])new AstNode[]{this.method}));
    }
}

