/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.semantic.ast.member.AccessorModifierUtil;
import apex.jorje.semantic.ast.member.AccessorType;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.tester.TestModifierGroups;
import apex.jorje.semantic.tester.matchers.IsResultWithError;
import apex.jorje.semantic.tester.matchers.IterableMatchers;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PropertyAccessorModifierTest {
    @DataProvider
    Object[][] versionedDefaultAccessorData() {
        return new Object[][]{{AccessorType.GETTER, TestModifierGroups.EMPTY, Version.V154, ImmutableList.of(ModifierTypeInfos.PUBLIC, ModifierTypeInfos.LEGACY_DEFAULT_GETTER)}, {AccessorType.GETTER, TestModifierGroups.PUBLIC, Version.V154, ImmutableList.of(ModifierTypeInfos.PUBLIC)}, {AccessorType.GETTER, TestModifierGroups.EMPTY, Version.V156, ImmutableList.of(ModifierTypeInfos.PRIVATE)}, {AccessorType.SETTER, TestModifierGroups.EMPTY, Version.V154, ImmutableList.of(ModifierTypeInfos.PUBLIC, ModifierTypeInfos.LEGACY_DEFAULT_SETTER)}, {AccessorType.SETTER, TestModifierGroups.PUBLIC, Version.V154, ImmutableList.of(ModifierTypeInfos.PUBLIC)}, {AccessorType.SETTER, TestModifierGroups.EMPTY, Version.V156, ImmutableList.of(ModifierTypeInfos.PRIVATE)}};
    }

    @Test(dataProvider="versionedDefaultAccessorData")
    public void testVersionedDefaultAccessor(AccessorType type, ModifierGroup propertyModifiers, Version version, List<ModifierTypeInfo> expectedModifiers) {
        this.scenario(type, propertyModifiers, TestModifierGroups.EMPTY, version, expectedModifiers);
    }

    @DataProvider
    Object[][] validAccessorData() {
        return new Object[][]{{ModifierGroups.GLOBAL, ModifierTypeInfos.GLOBAL}, {TestModifierGroups.PUBLIC, ModifierTypeInfos.PUBLIC}, {TestModifierGroups.PROTECTED, ModifierTypeInfos.PROTECTED}, {ModifierGroups.PRIVATE, ModifierTypeInfos.PRIVATE}};
    }

    @Test(dataProvider="validAccessorData")
    public void testDefaultAccessor(ModifierGroup propertyModifiers, ModifierTypeInfo expectedModifiers) {
        this.scenario(AccessorType.GETTER, propertyModifiers, TestModifierGroups.EMPTY, Version.CURRENT, ImmutableList.of(expectedModifiers));
        this.scenario(AccessorType.SETTER, propertyModifiers, TestModifierGroups.EMPTY, Version.CURRENT, ImmutableList.of(expectedModifiers));
    }

    @Test(dataProvider="validAccessorData")
    public void testExplicitAccessor(ModifierGroup accessorModifiers, ModifierTypeInfo expectedModifiers) {
        this.scenario(AccessorType.GETTER, ModifierGroups.GLOBAL, accessorModifiers, Version.CURRENT, ImmutableList.of(expectedModifiers));
        this.scenario(AccessorType.SETTER, ModifierGroups.GLOBAL, accessorModifiers, Version.CURRENT, ImmutableList.of(expectedModifiers));
    }

    @Test
    public void testIllegalAccessorVisibility() {
        Result<List<ModifierTypeInfo>> calculatedModifiers = AccessorModifierUtil.calculateAccessorModifiers(AccessorType.GETTER, ModifierGroups.PRIVATE, ModifierGroups.GLOBAL, Version.CURRENT);
        MatcherAssert.assertThat(calculatedModifiers, IsResultWithError.error(I18nSupport.getLabel("illegal.accessor.on.property", "global", "private")));
    }

    private void scenario(AccessorType type, ModifierGroup propertyModifiers, ModifierGroup accessorModifiers, Version version, List<ModifierTypeInfo> expectedModifiers) {
        Result<List<ModifierTypeInfo>> calculatedModifiers = AccessorModifierUtil.calculateAccessorModifiers(type, propertyModifiers, accessorModifiers, version);
        MatcherAssert.assertThat(calculatedModifiers.get(), IterableMatchers.containsInAnyOrder(expectedModifiers));
    }
}

