/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.ast.FormalParameter;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ParameterUtil {
    private ParameterUtil() {
    }

    public static List<Parameter> toNamed(TypeInfo definingType, List<TypeInfo> parameterTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            builder.add(Parameter.builder().setDefiningType(definingType).setName("arg" + i).setType(parameterTypes.get(i)).build());
        }
        return builder.build();
    }

    public static List<Parameter> toHidden(TypeInfo definingType, List<TypeInfo> parameterTypes) {
        return parameterTypes.stream().map(parameterType -> Parameter.builder().setType((TypeInfo)parameterType).setDefiningType(definingType).build()).collect(MoreIterables.toUnmodifiableList(parameterTypes.size()));
    }

    public static List<Parameter> toParameter(TypeInfo definingType, List<FormalParameter> parameters) {
        return parameters.stream().map(parameter -> Parameter.builder().setDefiningType(definingType).setType(parameter.type).setName(parameter.name).setModifiers(ModifierGroup.builder().setLoc(parameter.name.loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(parameter.modifiers).build()).build()).collect(MoreIterables.toUnmodifiableList(parameters.size()));
    }

    public static List<Parameter> copy(TypeInfo definingType, List<Parameter> parameters) {
        return parameters.stream().map(parameter -> Parameter.builder().setDefiningType(definingType).setType(parameter.getType()).setName(parameter.getName()).setModifiers(parameter.getModifierInfo()).build()).collect(MoreIterables.toUnmodifiableList(parameters.size()));
    }
}

