/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.MethodDecl;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestNode;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MethodFactoryTest {
    private static final Optional<TypeRef> SOME_CLASS = Optional.of(JadtTester.FOO_CLASS_TYPE);
    private static final AstNode NODE = TestNode.create(TypeInfos.INTEGER);
    @Mock
    private SymbolResolver symbols;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.symbols.lookupTypeInfo((TypeInfo)org.mockito.Matchers.any(TypeInfo.class), (TypeRef)org.mockito.Matchers.eq((Object)JadtTester.FOO_CLASS_TYPE))).thenReturn((Object)TypeInfos.INTEGER);
    }

    @Test
    public void testAnonymous() {
        Method method = MethodFactory.create(NODE, StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.ANONYMOUS).setModifiers(ModifierGroups.STATEMENT_EXECUTED), Statement.NOOP);
        method.resolve(this.symbols);
        MatcherAssert.assertThat((Object)((Object)method.getMethodInfo().getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.ANONYMOUS)));
    }

    @Test
    public void testUser() {
        Method method = MethodFactory.createUserMethod(NODE, MethodDecl._MethodDecl(JadtTester.EMPTY_MODIFIERS, SOME_CLASS, JadtFactory.identifier("method"), JadtTester.EMPTY_PARAMETER, Optional.empty()));
        method.resolve(this.symbols);
        MatcherAssert.assertThat((Object)((Object)method.getMethodInfo().getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.USER)));
    }
}

