/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.TriggerMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.Version;
import java.util.Optional;

public class AccessorFactory {
    private static final String PROPERTY_PREFIX = "__sfdc_";
    private static final String PARAM_NAME = "value";

    public static String name(String name) {
        return PROPERTY_PREFIX + name;
    }

    static Method createSetter(Property definingNode, PropertyDecl body, boolean isVoid, ModifierGroup modifiers) {
        Optional<Stmnt> stmnt = body.setter.map(value -> value.stmnt).orElse(Optional.empty());
        Parameter formalParameter = Parameter.builder().setDefiningType(definingNode.getDefiningType()).setType(body.type).setEmitType(isVoid ? TypeInfos.OBJECT : null).setName(PARAM_NAME).setModifiers(ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build()).build();
        Statement setter = stmnt.map(value -> AccessorFactory.explicitAccessor(definingNode, value)).orElse(AccessorFactory.implicitAccessor(definingNode, definingNode.getDefiningType().getUnitType() == UnitType.TRIGGER ? new DefaultTriggerSetter() : new DefaultSetter()));
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(definingNode.getDefiningType()).setName(Identifier._Identifier(body.name.loc, AccessorFactory.name(body.name.value))).setParameters(formalParameter).setReturnType(TypeInfos.VOID).setEmitSignature(isVoid ? SignatureFactory.create(AccessorFactory.name(body.name.value), (TypeInfo)TypeInfos.VOID, TypeInfos.OBJECT) : null).setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED).setPropertyAccessor(), setter);
    }

    static Method createGetter(Property definingNode, PropertyDecl body, ModifierGroup modifiers) {
        Optional<Stmnt> stmnt = body.getter.map(value -> value.stmnt).orElse(Optional.empty());
        Statement getter = stmnt.map(value -> AccessorFactory.explicitAccessor(definingNode, value)).orElse(AccessorFactory.implicitAccessor(definingNode, definingNode.getDefiningType().getUnitType() == UnitType.TRIGGER ? new DefaultTriggerGetter() : new DefaultGetter()));
        return MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(definingNode.getDefiningType()).setName(Identifier._Identifier(body.name.loc, AccessorFactory.name(body.name.value))).setReturnType(Optional.of(body.type)).setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED).setPropertyAccessor(), getter);
    }

    static boolean isVoidRef(TypeRef typeRef) {
        return typeRef.match(new TypeRef.MatchBlock<Boolean>(){

            @Override
            public Boolean _case(TypeRef.ClassTypeRef x) {
                return !x.className.isEmpty() && x.className.get((int)0).value.equalsIgnoreCase("void");
            }

            @Override
            public Boolean _case(TypeRef.ArrayTypeRef x) {
                return false;
            }
        });
    }

    private static Statement implicitAccessor(final Property definingNode, final AccessorEmitter accessor) {
        return new Statement(definingNode){

            @Override
            public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
            }

            @Override
            public Loc getLoc() {
                return definingNode.getLoc();
            }

            @Override
            public void validate(SymbolResolver symbols, ValidationScope scope) {
                this.setReturnable(true);
            }

            @Override
            public void emit(Emitter emitter) {
                accessor.emit(emitter, definingNode.getFieldInfo(), definingNode.getLoc());
            }
        };
    }

    private static Statement explicitAccessor(Property definingNode, Stmnt stmnt) {
        final Statement statement = AstNodeFactory.create((AstNode)definingNode, stmnt);
        return new Statement(definingNode){

            @Override
            public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
                statement.traverse(visitor, scope);
            }

            @Override
            public void validate(SymbolResolver symbols, ValidationScope scope) {
                this.setReturnable(statement.isReturnable());
                statement.validate(symbols, scope);
            }

            @Override
            public void emit(Emitter emitter) {
                SystemModeEmit.builder().setBody(statement).setType(emitter.getType()).build().emit(emitter);
            }

            @Override
            public Loc getLoc() {
                return statement.getLoc();
            }
        };
    }

    private static class DefaultGetter
    implements AccessorEmitter {
        private DefaultGetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Loc loc) {
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                emitter.emitField(loc, 178, fieldInfo);
            } else {
                emitter.emitVar(loc, 25, 0);
                emitter.emitField(loc, 180, fieldInfo);
            }
            emitter.emit(loc, 176);
        }
    }

    private static class DefaultTriggerGetter
    implements AccessorEmitter {
        private DefaultTriggerGetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Loc loc) {
            emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
            emitter.emitField(loc, 180, fieldInfo);
            emitter.emit(loc, 176);
        }
    }

    private static class DefaultTriggerSetter
    implements AccessorEmitter {
        private DefaultTriggerSetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Loc loc) {
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(emitter).isGreaterThanOrEqual(Version.V160)) {
                emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
                emitter.emitField(Loc._SyntheticLoc(), 180, fieldInfo);
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.checkFinal());
            }
            emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
            emitter.emitVar(loc, 25, 1);
            emitter.emitField(loc, 181, fieldInfo);
            emitter.emit(loc, 177);
        }
    }

    private static class DefaultSetter
    implements AccessorEmitter {
        private DefaultSetter() {
        }

        @Override
        public void emit(Emitter emitter, FieldInfo fieldInfo, Loc loc) {
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.FINAL) && VersionUtil.get(emitter).isGreaterThanOrEqual(Version.V160)) {
                if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    emitter.emitField(Loc._SyntheticLoc(), 178, fieldInfo);
                } else {
                    emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                    emitter.emitField(Loc._SyntheticLoc(), 180, fieldInfo);
                }
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.checkFinal());
            }
            emitter.emitVar(loc, 25, 0);
            if (!fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                emitter.emitVar(loc, 25, 1);
                emitter.emitField(loc, 181, fieldInfo);
            } else {
                emitter.emitField(loc, 179, fieldInfo);
            }
            emitter.emit(loc, 177);
        }
    }

    private static interface AccessorEmitter {
        public void emit(Emitter var1, FieldInfo var2, Loc var3);
    }
}

