/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.TriggerVariable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;

public class TriggerVariableExpression
extends Expression {
    private final Loc loc;
    private final String name;
    private TriggerVariable variable;

    public TriggerVariableExpression(AstNode definingNode, Expr.TriggerVariableExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.name = x.variable.value;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.variable = symbols.getTriggerVariable(this.getDefiningType(), this.name);
        if (this.variable == null) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("variable.does.not.exist", this.name));
            return;
        }
        this.setType(this.variable.getType());
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emit(Loc._SyntheticLoc(), this.variable.getFunction());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

